/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.xmpp.config;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.roster.Roster;
import org.jivesoftware.smack.tcp.XMPPTCPConnection;
import org.jivesoftware.smack.tcp.XMPPTCPConnectionConfiguration;
import org.jxmpp.stringprep.XmppStringprepException;
import org.jxmpp.util.XmppStringUtils;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.config.AbstractFactoryBean;
import org.springframework.context.SmartLifecycle;
import org.springframework.util.StringUtils;

public class XmppConnectionFactoryBean
extends AbstractFactoryBean<XMPPConnection>
implements SmartLifecycle {
    private final Lock lifecycleMonitor = new ReentrantLock();
    private XMPPTCPConnectionConfiguration connectionConfiguration;
    private String resource;
    private String user;
    private String password;
    private String serviceName;
    private String host;
    private int port = 5222;
    private Roster.SubscriptionMode subscriptionMode = Roster.getDefaultSubscriptionMode();
    private boolean autoStartup = true;
    private int phase = Integer.MIN_VALUE;
    private volatile boolean running;

    public void setConnectionConfiguration(XMPPTCPConnectionConfiguration connectionConfiguration) {
        this.connectionConfiguration = connectionConfiguration;
    }

    public void setAutoStartup(boolean autoStartup) {
        this.autoStartup = autoStartup;
    }

    public void setPhase(int phase) {
        this.phase = phase;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setSubscriptionMode(Roster.SubscriptionMode subscriptionMode) {
        this.subscriptionMode = subscriptionMode;
    }

    public Class<? extends XMPPConnection> getObjectType() {
        return XMPPConnection.class;
    }

    protected XMPPConnection createInstance() throws XmppStringprepException {
        XMPPTCPConnectionConfiguration connectionConfig = this.connectionConfiguration;
        if (connectionConfig == null) {
            XMPPTCPConnectionConfiguration.Builder builder = (XMPPTCPConnectionConfiguration.Builder)((XMPPTCPConnectionConfiguration.Builder)XMPPTCPConnectionConfiguration.builder().setHost((CharSequence)this.host)).setPort(this.port);
            if (StringUtils.hasText((String)this.resource)) {
                builder.setResource((CharSequence)this.resource);
            }
            if (StringUtils.hasText((String)this.serviceName)) {
                ((XMPPTCPConnectionConfiguration.Builder)builder.setUsernameAndPassword((CharSequence)this.user, this.password)).setXmppDomain(this.serviceName);
            } else {
                ((XMPPTCPConnectionConfiguration.Builder)builder.setUsernameAndPassword((CharSequence)XmppStringUtils.parseLocalpart((String)this.user), this.password)).setXmppDomain(this.user);
            }
            connectionConfig = builder.build();
        }
        return new XMPPTCPConnection(connectionConfig);
    }

    protected XMPPTCPConnection getConnection() {
        try {
            return (XMPPTCPConnection)this.getObject();
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot obtain connection instance", e);
        }
    }

    public void start() {
        this.lifecycleMonitor.lock();
        try {
            if (this.running) {
                return;
            }
            XMPPTCPConnection connection = this.getConnection();
            try {
                connection.connect();
                connection.addConnectionListener((ConnectionListener)new LoggingConnectionListener());
                Roster roster = Roster.getInstanceFor((XMPPConnection)connection);
                if (this.subscriptionMode != null) {
                    roster.setSubscriptionMode(this.subscriptionMode);
                } else {
                    roster.setRosterLoadedAtLogin(false);
                }
                connection.login();
                this.running = true;
            }
            catch (Exception e) {
                throw new BeanInitializationException("failed to connect to XMPP service for " + connection.getXMPPServiceDomain(), (Throwable)e);
            }
        }
        finally {
            this.lifecycleMonitor.unlock();
        }
    }

    public void stop() {
        this.lifecycleMonitor.lock();
        try {
            if (this.isRunning()) {
                this.getConnection().disconnect();
                this.running = false;
            }
        }
        finally {
            this.lifecycleMonitor.unlock();
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    public int getPhase() {
        return this.phase;
    }

    public boolean isAutoStartup() {
        return this.autoStartup;
    }

    private class LoggingConnectionListener
    implements ConnectionListener {
        LoggingConnectionListener() {
        }

        public void connectionClosedOnError(Exception e) {
            XmppConnectionFactoryBean.this.logger.debug((Object)"Connection closed on error", (Throwable)e);
        }

        public void connectionClosed() {
            XmppConnectionFactoryBean.this.logger.debug((Object)"Connection closed");
        }

        public void connected(XMPPConnection connection) {
            XmppConnectionFactoryBean.this.logger.debug((Object)"Connection connected");
        }

        public void authenticated(XMPPConnection connection, boolean resumed) {
            XmppConnectionFactoryBean.this.logger.debug((Object)"Connection authenticated");
        }
    }
}

