/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.zookeeper.metadata;

import java.io.Closeable;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.BackgroundPathAndBytesable;
import org.apache.curator.framework.api.WatchPathable;
import org.apache.curator.framework.recipes.cache.ChildData;
import org.apache.curator.framework.recipes.cache.PathChildrenCache;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheEvent;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheListener;
import org.apache.curator.utils.CloseableUtils;
import org.apache.curator.utils.EnsurePath;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;
import org.springframework.context.SmartLifecycle;
import org.springframework.integration.metadata.ListenableMetadataStore;
import org.springframework.integration.metadata.MetadataStoreListener;
import org.springframework.integration.support.utils.IntegrationUtils;
import org.springframework.integration.zookeeper.metadata.ZookeeperMetadataStoreException;
import org.springframework.util.Assert;

public class ZookeeperMetadataStore
implements ListenableMetadataStore,
SmartLifecycle {
    private final Object lifecycleMonitor = new Object();
    private final CuratorFramework client;
    private final List<MetadataStoreListener> listeners = new CopyOnWriteArrayList<MetadataStoreListener>();
    private final ConcurrentMap<String, LocalChildData> updateMap = new ConcurrentHashMap<String, LocalChildData>();
    private volatile String root = "/SpringIntegration-MetadataStore";
    private volatile String encoding = "UTF-8";
    private volatile PathChildrenCache cache;
    private volatile boolean running = false;
    private volatile boolean autoStartup = true;
    private volatile int phase = Integer.MAX_VALUE;

    public ZookeeperMetadataStore(CuratorFramework client) throws Exception {
        Assert.notNull((Object)client, (String)"Client cannot be null");
        this.client = client;
    }

    public void setEncoding(String encoding) {
        Assert.hasText((String)encoding, (String)"'encoding' cannot be null or empty.");
        this.encoding = encoding;
    }

    public void setRoot(String root) {
        Assert.notNull((Object)root, (String)"'root' must not be null.");
        Assert.isTrue((boolean)root.startsWith("/"), (String)"'root' must start with '/'");
        this.root = "/".equals(root) || !root.endsWith("/") ? root : root.substring(0, root.length() - 1);
    }

    public String getRoot() {
        return this.root;
    }

    public void setAutoStartup(boolean autoStartup) {
        this.autoStartup = autoStartup;
    }

    public void setPhase(int phase) {
        this.phase = phase;
    }

    public String putIfAbsent(String key, String value) {
        Assert.notNull((Object)key, (String)"'key' must not be null.");
        Assert.notNull((Object)value, (String)"'value' must not be null.");
        ConcurrentMap<String, LocalChildData> concurrentMap = this.updateMap;
        synchronized (concurrentMap) {
            try {
                this.createNode(key, value);
                return null;
            }
            catch (KeeperException.NodeExistsException e) {
                try {
                    byte[] bytes = (byte[])this.client.getData().forPath(this.getPath(key));
                    return IntegrationUtils.bytesToString((byte[])bytes, (String)this.encoding);
                }
                catch (Exception exceptionDuringGet) {
                    throw new ZookeeperMetadataStoreException("Exception while reading node with key '" + key + "':", e);
                }
            }
            catch (Exception e) {
                throw new ZookeeperMetadataStoreException("Error while trying to set '" + key + "':", e);
            }
        }
    }

    public boolean replace(String key, String oldValue, String newValue) {
        Assert.notNull((Object)key, (String)"'key' must not be null.");
        Assert.notNull((Object)oldValue, (String)"'oldValue' must not be null.");
        Assert.notNull((Object)newValue, (String)"'newValue' must not be null.");
        ConcurrentMap<String, LocalChildData> concurrentMap = this.updateMap;
        synchronized (concurrentMap) {
            Stat currentStat = new Stat();
            try {
                byte[] bytes = (byte[])((WatchPathable)this.client.getData().storingStatIn(currentStat)).forPath(this.getPath(key));
                if (oldValue.equals(IntegrationUtils.bytesToString((byte[])bytes, (String)this.encoding))) {
                    this.updateNode(key, newValue, currentStat.getVersion());
                }
                return true;
            }
            catch (KeeperException.NoNodeException e) {
                return false;
            }
            catch (KeeperException.BadVersionException e) {
                return false;
            }
            catch (Exception e) {
                throw new ZookeeperMetadataStoreException("Cannot replace value");
            }
        }
    }

    public void addListener(MetadataStoreListener callback) {
        this.listeners.add(callback);
    }

    public void removeListener(MetadataStoreListener callback) {
        this.listeners.remove(callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(String key, String value) {
        Assert.notNull((Object)key, (String)"'key' must not be null.");
        Assert.notNull((Object)value, (String)"'value' must not be null.");
        ConcurrentMap<String, LocalChildData> concurrentMap = this.updateMap;
        synchronized (concurrentMap) {
            try {
                Stat currentNode = (Stat)this.client.checkExists().forPath(this.getPath(key));
                if (currentNode == null) {
                    try {
                        this.createNode(key, value);
                    }
                    catch (KeeperException.NodeExistsException e) {
                        this.updateNode(key, value, -1);
                    }
                } else {
                    this.updateNode(key, value, -1);
                }
            }
            catch (Exception e) {
                throw new ZookeeperMetadataStoreException("Error while setting value for key '" + key + "':", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get(String key) {
        Assert.notNull((Object)key, (String)"'key' must not be null.");
        ConcurrentMap<String, LocalChildData> concurrentMap = this.updateMap;
        synchronized (concurrentMap) {
            ChildData currentData = this.cache.getCurrentData(this.getPath(key));
            if (currentData == null) {
                if (this.updateMap.containsKey(key)) {
                    return ((LocalChildData)this.updateMap.get(key)).getValue();
                }
                return null;
            }
            if (this.updateMap.containsKey(key) && ((LocalChildData)this.updateMap.get(key)).getVersion() >= currentData.getStat().getVersion()) {
                return ((LocalChildData)this.updateMap.get(key)).getValue();
            }
            return IntegrationUtils.bytesToString((byte[])currentData.getData(), (String)this.encoding);
        }
    }

    public String remove(String key) {
        Assert.notNull((Object)key, (String)"'key' must not be null.");
        ConcurrentMap<String, LocalChildData> concurrentMap = this.updateMap;
        synchronized (concurrentMap) {
            try {
                byte[] bytes = (byte[])this.client.getData().forPath(this.getPath(key));
                this.client.delete().forPath(this.getPath(key));
                this.updateMap.put(key, new LocalChildData(null, Integer.MAX_VALUE));
                return IntegrationUtils.bytesToString((byte[])bytes, (String)this.encoding);
            }
            catch (KeeperException.NoNodeException e) {
                return null;
            }
            catch (Exception e) {
                throw new ZookeeperMetadataStoreException("Exception while deleting key '" + key + "'", e);
            }
        }
    }

    private void updateNode(String key, String value, int version) throws Exception {
        Stat stat = (Stat)((BackgroundPathAndBytesable)this.client.setData().withVersion(version)).forPath(this.getPath(key), IntegrationUtils.stringToBytes((String)value, (String)this.encoding));
        this.updateMap.put(key, new LocalChildData(value, stat.getVersion()));
    }

    private void createNode(String key, String value) throws Exception {
        this.client.create().forPath(this.getPath(key), IntegrationUtils.stringToBytes((String)value, (String)this.encoding));
        this.updateMap.put(key, new LocalChildData(value, 0));
    }

    public String getPath(String key) {
        return "".equals(key) ? this.root : this.root + "/" + key;
    }

    public boolean isAutoStartup() {
        return this.autoStartup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        if (!this.running) {
            Object object = this.lifecycleMonitor;
            synchronized (object) {
                if (!this.running) {
                    try {
                        EnsurePath ensurePath = new EnsurePath(this.root);
                        ensurePath.ensure(this.client.getZookeeperClient());
                        this.cache = new PathChildrenCache(this.client, this.root, true);
                        this.cache.getListenable().addListener((Object)new MetadataStoreListenerInvokingPathChildrenCacheListener());
                        this.cache.start(PathChildrenCache.StartMode.BUILD_INITIAL_CACHE);
                        this.running = true;
                    }
                    catch (Exception e) {
                        throw new ZookeeperMetadataStoreException("Exception while starting bean", e);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (this.running) {
            Object object = this.lifecycleMonitor;
            synchronized (object) {
                if (this.running) {
                    if (this.cache != null) {
                        CloseableUtils.closeQuietly((Closeable)this.cache);
                    }
                    this.cache = null;
                    this.running = false;
                }
            }
        }
    }

    public void stop(Runnable callback) {
        this.stop();
        callback.run();
    }

    public boolean isRunning() {
        return this.running;
    }

    public int getPhase() {
        return this.phase;
    }

    private String getKey(String path) {
        return path.replace(this.root + "/", "");
    }

    private class MetadataStoreListenerInvokingPathChildrenCacheListener
    implements PathChildrenCacheListener {
        private MetadataStoreListenerInvokingPathChildrenCacheListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void childEvent(CuratorFramework client, PathChildrenCacheEvent event) throws Exception {
            ConcurrentMap concurrentMap = ZookeeperMetadataStore.this.updateMap;
            synchronized (concurrentMap) {
                String eventPath = event.getData().getPath();
                String eventKey = ZookeeperMetadataStore.this.getKey(eventPath);
                byte[] eventData = event.getData().getData();
                switch (event.getType()) {
                    case CHILD_ADDED: {
                        if (ZookeeperMetadataStore.this.updateMap.containsKey(eventKey) && event.getData().getStat().getVersion() >= ((LocalChildData)ZookeeperMetadataStore.this.updateMap.get(eventKey)).getVersion()) {
                            ZookeeperMetadataStore.this.updateMap.remove(eventPath);
                        }
                        for (MetadataStoreListener listener : ZookeeperMetadataStore.this.listeners) {
                            listener.onAdd(eventKey, IntegrationUtils.bytesToString((byte[])eventData, (String)ZookeeperMetadataStore.this.encoding));
                        }
                        break;
                    }
                    case CHILD_UPDATED: {
                        if (ZookeeperMetadataStore.this.updateMap.containsKey(eventKey) && event.getData().getStat().getVersion() >= ((LocalChildData)ZookeeperMetadataStore.this.updateMap.get(eventKey)).getVersion()) {
                            ZookeeperMetadataStore.this.updateMap.remove(eventPath);
                        }
                        for (MetadataStoreListener listener : ZookeeperMetadataStore.this.listeners) {
                            listener.onUpdate(eventKey, IntegrationUtils.bytesToString((byte[])eventData, (String)ZookeeperMetadataStore.this.encoding));
                        }
                        break;
                    }
                    case CHILD_REMOVED: {
                        ZookeeperMetadataStore.this.updateMap.remove(eventKey);
                        for (MetadataStoreListener listener : ZookeeperMetadataStore.this.listeners) {
                            listener.onRemove(eventKey, IntegrationUtils.bytesToString((byte[])eventData, (String)ZookeeperMetadataStore.this.encoding));
                        }
                        break;
                    }
                }
            }
        }
    }

    private static class LocalChildData {
        private final String value;
        private final int version;

        public LocalChildData(String value, int version) {
            this.value = value;
            this.version = version;
        }

        public String getValue() {
            return this.value;
        }

        public int getVersion() {
            return this.version;
        }
    }
}

