/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.zookeeper.lock;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.recipes.locks.InterProcessMutex;
import org.apache.zookeeper.CreateMode;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.core.task.AsyncTaskExecutor;
import org.springframework.integration.support.locks.ExpirableLockRegistry;
import org.springframework.messaging.MessagingException;
import org.springframework.scheduling.concurrent.ExecutorConfigurationSupport;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.util.Assert;

public class ZookeeperLockRegistry
implements ExpirableLockRegistry,
DisposableBean {
    private static final String DEFAULT_ROOT = "/SpringIntegration-LockRegistry";
    private final CuratorFramework client;
    private final KeyToPathStrategy keyToPath;
    private final Map<String, ZkLock> locks = new ConcurrentHashMap<String, ZkLock>();
    private final boolean trackingTime;
    private AsyncTaskExecutor mutexTaskExecutor = new ThreadPoolTaskExecutor();
    private boolean mutexTaskExecutorExplicitlySet;

    public ZookeeperLockRegistry(CuratorFramework client) {
        this(client, DEFAULT_ROOT);
    }

    public ZookeeperLockRegistry(CuratorFramework client, String root) {
        this(client, new DefaultKeyToPathStrategy(root));
    }

    public ZookeeperLockRegistry(CuratorFramework client, KeyToPathStrategy keyToPath) {
        ThreadPoolTaskExecutor threadPoolTaskExecutor = (ThreadPoolTaskExecutor)this.mutexTaskExecutor;
        threadPoolTaskExecutor.setAllowCoreThreadTimeOut(true);
        threadPoolTaskExecutor.setBeanName("ZookeeperLockRegistryExecutor");
        threadPoolTaskExecutor.initialize();
        Assert.notNull((Object)client, (String)"'client' cannot be null");
        Assert.notNull((Object)client, (String)"'keyToPath' cannot be null");
        this.client = client;
        this.keyToPath = keyToPath;
        this.trackingTime = !keyToPath.bounded();
    }

    public void setMutexTaskExecutor(AsyncTaskExecutor mutexTaskExecutor) {
        Assert.notNull((Object)mutexTaskExecutor, (String)"'mutexTaskExecutor' cannot be null");
        ((ExecutorConfigurationSupport)this.mutexTaskExecutor).shutdown();
        this.mutexTaskExecutor = mutexTaskExecutor;
        this.mutexTaskExecutorExplicitlySet = true;
    }

    public Lock obtain(Object lockKey) {
        Assert.isInstanceOf(String.class, (Object)lockKey);
        String path = this.keyToPath.pathFor((String)lockKey);
        ZkLock lock = this.locks.computeIfAbsent(path, p -> new ZkLock(this.client, this.mutexTaskExecutor, (String)p));
        if (this.trackingTime) {
            lock.setLastUsed(System.currentTimeMillis());
        }
        return lock;
    }

    public void expireUnusedOlderThan(long age) {
        if (!this.trackingTime) {
            throw new IllegalStateException("Ths KeyToPathStrategy is bounded; expiry is not supported");
        }
        Iterator<Map.Entry<String, ZkLock>> iterator = this.locks.entrySet().iterator();
        long now = System.currentTimeMillis();
        while (iterator.hasNext()) {
            Map.Entry<String, ZkLock> entry = iterator.next();
            ZkLock lock = entry.getValue();
            if (now - lock.getLastUsed() <= age || lock.isAcquiredInThisProcess()) continue;
            iterator.remove();
        }
    }

    public void destroy() throws Exception {
        if (!this.mutexTaskExecutorExplicitlySet) {
            ((ExecutorConfigurationSupport)this.mutexTaskExecutor).shutdown();
        }
    }

    private static final class ZkLock
    implements Lock {
        private final CuratorFramework client;
        private final InterProcessMutex mutex;
        private final AsyncTaskExecutor mutexTaskExecutor;
        private final String path;
        private long lastUsed;

        ZkLock(CuratorFramework client, AsyncTaskExecutor mutexTaskExecutor, String path) {
            this.client = client;
            this.mutex = new InterProcessMutex(client, path);
            this.mutexTaskExecutor = mutexTaskExecutor;
            this.path = path;
        }

        public long getLastUsed() {
            return this.lastUsed;
        }

        public void setLastUsed(long lastUsed) {
            this.lastUsed = lastUsed;
        }

        @Override
        public void lock() {
            try {
                this.mutex.acquire();
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to acquire mutex at " + this.path, e);
            }
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
            boolean locked = false;
            while (!locked) {
                locked = this.tryLock(1L, TimeUnit.SECONDS);
            }
        }

        @Override
        public boolean tryLock() {
            try {
                return this.tryLock(1L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return false;
            }
        }

        @Override
        public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
            Future future = null;
            try {
                long startTime = System.currentTimeMillis();
                future = this.mutexTaskExecutor.submit((Callable)new Callable<String>(){

                    @Override
                    public String call() throws Exception {
                        return (String)((ACLBackgroundPathAndBytesable)client.create().creatingParentContainersIfNeeded().withProtection().withMode(CreateMode.EPHEMERAL_SEQUENTIAL)).forPath(path);
                    }
                });
                long waitTime = unit.toMillis(time);
                String ourPath = (String)future.get(waitTime, TimeUnit.MILLISECONDS);
                if (ourPath == null) {
                    future.cancel(true);
                    return false;
                }
                return this.mutex.acquire(waitTime -= System.currentTimeMillis() - startTime, TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException e) {
                future.cancel(true);
                return false;
            }
            catch (Exception e) {
                throw new MessagingException("Failed to acquire mutex at " + this.path, (Throwable)e);
            }
        }

        @Override
        public void unlock() {
            try {
                this.mutex.release();
            }
            catch (Exception e) {
                throw new MessagingException("Failed to release mutex at " + this.path, (Throwable)e);
            }
        }

        @Override
        public Condition newCondition() {
            throw new UnsupportedOperationException("Conditions are not supported");
        }

        public boolean isAcquiredInThisProcess() {
            return this.mutex.isAcquiredInThisProcess();
        }
    }

    private static final class DefaultKeyToPathStrategy
    implements KeyToPathStrategy {
        private final String root;

        DefaultKeyToPathStrategy(String rootPath) {
            Assert.notNull((Object)rootPath, (String)"'rootPath' cannot be null");
            this.root = !rootPath.endsWith("/") ? rootPath + "/" : rootPath;
        }

        @Override
        public String pathFor(String key) {
            return this.root + key;
        }

        @Override
        public boolean bounded() {
            return false;
        }
    }

    @FunctionalInterface
    public static interface KeyToPathStrategy {
        public String pathFor(String var1);

        default public boolean bounded() {
            return true;
        }
    }
}

