/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.listener;

import java.util.Collection;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.common.TopicPartition;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.context.SmartLifecycle;
import org.springframework.kafka.listener.GenericMessageListener;
import org.springframework.kafka.listener.KafkaDataListener;
import org.springframework.kafka.listener.MessageListenerContainer;
import org.springframework.kafka.listener.config.ContainerProperties;
import org.springframework.util.Assert;

public abstract class AbstractMessageListenerContainer<K, V>
implements MessageListenerContainer,
BeanNameAware,
ApplicationEventPublisherAware,
SmartLifecycle {
    public static final int DEFAULT_PHASE = 2147483547;
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final ContainerProperties containerProperties;
    private final Object lifecycleMonitor = new Object();
    private String beanName;
    private ApplicationEventPublisher applicationEventPublisher;
    private boolean autoStartup = true;
    private int phase = 2147483547;
    private volatile boolean running = false;

    protected AbstractMessageListenerContainer(ContainerProperties containerProperties) {
        Assert.notNull((Object)containerProperties, (String)"'containerProperties' cannot be null");
        this.containerProperties = containerProperties.getTopics() != null ? new ContainerProperties(containerProperties.getTopics()) : (containerProperties.getTopicPattern() != null ? new ContainerProperties(containerProperties.getTopicPattern()) : new ContainerProperties(containerProperties.getTopicPartitions()));
        BeanUtils.copyProperties((Object)containerProperties, (Object)this.containerProperties, (String[])new String[]{"topics", "topicPartitions", "topicPattern", "ackCount", "ackTime"});
        if (containerProperties.getAckCount() > 0) {
            this.containerProperties.setAckCount(containerProperties.getAckCount());
        }
        if (containerProperties.getAckTime() > 0L) {
            this.containerProperties.setAckTime(containerProperties.getAckTime());
        }
        if (this.containerProperties.getConsumerRebalanceListener() == null) {
            this.containerProperties.setConsumerRebalanceListener(this.createConsumerRebalanceListener());
        }
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }

    public String getBeanName() {
        return this.beanName;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    public ApplicationEventPublisher getApplicationEventPublisher() {
        return this.applicationEventPublisher;
    }

    public boolean isAutoStartup() {
        return this.autoStartup;
    }

    public void setAutoStartup(boolean autoStartup) {
        this.autoStartup = autoStartup;
    }

    protected void setRunning(boolean running) {
        this.running = running;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void setPhase(int phase) {
        this.phase = phase;
    }

    public int getPhase() {
        return this.phase;
    }

    public ContainerProperties getContainerProperties() {
        return this.containerProperties;
    }

    @Override
    public void setupMessageListener(Object messageListener) {
        this.containerProperties.setMessageListener(messageListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void start() {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            if (!this.isRunning()) {
                Assert.isTrue((boolean)(this.containerProperties.getMessageListener() instanceof KafkaDataListener), (String)("A " + GenericMessageListener.class.getName() + " implementation must be provided"));
                this.doStart();
            }
        }
    }

    protected abstract void doStart();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop() {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            if (this.isRunning()) {
                final CountDownLatch latch = new CountDownLatch(1);
                this.doStop(new Runnable(){

                    @Override
                    public void run() {
                        latch.countDown();
                    }
                });
                try {
                    latch.await(this.containerProperties.getShutdownTimeout(), TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(Runnable callback) {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            if (this.isRunning()) {
                this.doStop(callback);
            }
        }
    }

    protected abstract void doStop(Runnable var1);

    protected final ConsumerRebalanceListener createConsumerRebalanceListener() {
        return new ConsumerRebalanceListener(){

            public void onPartitionsRevoked(Collection<TopicPartition> partitions) {
                AbstractMessageListenerContainer.this.logger.info((Object)("partitions revoked:" + partitions));
            }

            public void onPartitionsAssigned(Collection<TopicPartition> partitions) {
                AbstractMessageListenerContainer.this.logger.info((Object)("partitions assigned:" + partitions));
            }
        };
    }

    public static enum AckMode {
        RECORD,
        BATCH,
        TIME,
        COUNT,
        COUNT_TIME,
        MANUAL,
        MANUAL_IMMEDIATE;

    }
}

