/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.listener;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import org.apache.commons.logging.LogFactory;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.OffsetCommitCallback;
import org.apache.kafka.common.TopicPartition;
import org.springframework.classify.BinaryExceptionClassifier;
import org.springframework.core.log.LogAccessor;
import org.springframework.kafka.KafkaException;
import org.springframework.kafka.listener.ContainerAwareErrorHandler;
import org.springframework.kafka.listener.ContainerProperties;
import org.springframework.kafka.listener.FailedRecordTracker;
import org.springframework.kafka.listener.LoggingCommitCallback;
import org.springframework.kafka.listener.MessageListenerContainer;
import org.springframework.kafka.support.SeekUtils;
import org.springframework.kafka.support.serializer.DeserializationException;
import org.springframework.lang.Nullable;
import org.springframework.messaging.converter.MessageConversionException;
import org.springframework.messaging.handler.invocation.MethodArgumentResolutionException;
import org.springframework.util.Assert;
import org.springframework.util.backoff.BackOff;
import org.springframework.util.backoff.FixedBackOff;

public class SeekToCurrentErrorHandler
implements ContainerAwareErrorHandler {
    private static final BiPredicate<ConsumerRecord<?, ?>, Exception> ALWAYS_SKIP_PREDICATE = (r, e) -> true;
    protected static final LogAccessor LOGGER = new LogAccessor(LogFactory.getLog(SeekToCurrentErrorHandler.class));
    private static final LoggingCommitCallback LOGGING_COMMIT_CALLBACK = new LoggingCommitCallback();
    private final FailedRecordTracker failureTracker;
    private boolean commitRecovered;
    private BinaryExceptionClassifier classifier;

    public SeekToCurrentErrorHandler() {
        this(null, (BackOff)SeekUtils.DEFAULT_BACK_OFF);
    }

    @Deprecated
    public SeekToCurrentErrorHandler(int maxFailures) {
        this(null, maxFailures);
    }

    public SeekToCurrentErrorHandler(BackOff backOff) {
        this(null, backOff);
    }

    public SeekToCurrentErrorHandler(BiConsumer<ConsumerRecord<?, ?>, Exception> recoverer) {
        this(recoverer, (BackOff)SeekUtils.DEFAULT_BACK_OFF);
    }

    @Deprecated
    public SeekToCurrentErrorHandler(@Nullable BiConsumer<ConsumerRecord<?, ?>, Exception> recoverer, int maxFailures) {
        this.failureTracker = new FailedRecordTracker(recoverer, (BackOff)new FixedBackOff(0L, (long)(maxFailures - 1)), LOGGER);
        this.classifier = SeekToCurrentErrorHandler.configureDefaultClassifier();
    }

    public SeekToCurrentErrorHandler(@Nullable BiConsumer<ConsumerRecord<?, ?>, Exception> recoverer, BackOff backOff) {
        this.failureTracker = new FailedRecordTracker(recoverer, backOff, LOGGER);
        this.classifier = SeekToCurrentErrorHandler.configureDefaultClassifier();
    }

    protected boolean isCommitRecovered() {
        return this.commitRecovered;
    }

    public void setCommitRecovered(boolean commitRecovered) {
        this.commitRecovered = commitRecovered;
    }

    protected BinaryExceptionClassifier getClassifier() {
        return this.classifier;
    }

    public void setClassifier(BinaryExceptionClassifier classifier) {
        Assert.notNull((Object)classifier, (String)"'classifier' + cannot be null");
        classifier.setTraverseCauses(true);
        this.classifier = classifier;
    }

    public void addNotRetryableException(Class<? extends Exception> exceptionType) {
        Assert.isTrue((boolean)(this.classifier instanceof ExtendedBinaryExceptionClassifier), (String)"Cannot add exception types to a supplied classifier");
        ((ExtendedBinaryExceptionClassifier)this.classifier).getClassified().put(exceptionType, false);
    }

    public boolean removeNotRetryableException(Class<? extends Exception> exceptionType) {
        Assert.isTrue((boolean)(this.classifier instanceof ExtendedBinaryExceptionClassifier), (String)"Cannot remove exception types from a supplied classifier");
        return ((ExtendedBinaryExceptionClassifier)this.classifier).getClassified().remove(exceptionType);
    }

    @Override
    public void handle(Exception thrownException, List<ConsumerRecord<?, ?>> records, Consumer<?, ?> consumer, MessageListenerContainer container) {
        if (!SeekUtils.doSeeks(records, consumer, thrownException, true, this.getSkipPredicate(records, thrownException), LOGGER)) {
            throw new KafkaException("Seek to current after exception", thrownException);
        }
        if (this.commitRecovered) {
            if (container.getContainerProperties().getAckMode().equals((Object)ContainerProperties.AckMode.MANUAL_IMMEDIATE)) {
                ConsumerRecord<?, ?> record = records.get(0);
                Map<TopicPartition, OffsetAndMetadata> offsetToCommit = Collections.singletonMap(new TopicPartition(record.topic(), record.partition()), new OffsetAndMetadata(record.offset() + 1L));
                if (container.getContainerProperties().isSyncCommits()) {
                    consumer.commitSync(offsetToCommit, container.getContainerProperties().getSyncCommitTimeout());
                } else {
                    OffsetCommitCallback commitCallback = container.getContainerProperties().getCommitCallback();
                    if (commitCallback == null) {
                        commitCallback = LOGGING_COMMIT_CALLBACK;
                    }
                    consumer.commitAsync(offsetToCommit, commitCallback);
                }
            } else {
                LOGGER.warn(() -> "'commitRecovered' ignored, container AckMode must be MANUAL_IMMEDIATE, not " + (Object)((Object)container.getContainerProperties().getAckMode()));
            }
        }
    }

    private BiPredicate<ConsumerRecord<?, ?>, Exception> getSkipPredicate(List<ConsumerRecord<?, ?>> records, Exception thrownException) {
        if (this.classifier.classify((Throwable)thrownException).booleanValue()) {
            return this.failureTracker::skip;
        }
        this.failureTracker.getRecoverer().accept(records.get(0), thrownException);
        return ALWAYS_SKIP_PREDICATE;
    }

    @Override
    public void clearThreadState() {
        this.failureTracker.clearThreadState();
    }

    private static BinaryExceptionClassifier configureDefaultClassifier() {
        HashMap<Class<? extends Throwable>, Boolean> classified = new HashMap<Class<? extends Throwable>, Boolean>();
        classified.put(DeserializationException.class, false);
        classified.put(MessageConversionException.class, false);
        classified.put(MethodArgumentResolutionException.class, false);
        classified.put(NoSuchMethodException.class, false);
        classified.put(ClassCastException.class, false);
        ExtendedBinaryExceptionClassifier defaultClassifier = new ExtendedBinaryExceptionClassifier(classified, true);
        defaultClassifier.setTraverseCauses(true);
        return defaultClassifier;
    }

    private static class ExtendedBinaryExceptionClassifier
    extends BinaryExceptionClassifier {
        ExtendedBinaryExceptionClassifier(Map<Class<? extends Throwable>, Boolean> typeMap, boolean defaultValue) {
            super(typeMap, defaultValue);
        }

        protected Map<Class<? extends Throwable>, Boolean> getClassified() {
            return super.getClassified();
        }
    }
}

