/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.listener;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.OffsetCommitCallback;
import org.apache.kafka.common.TopicPartition;
import org.springframework.classify.BinaryExceptionClassifier;
import org.springframework.kafka.KafkaException;
import org.springframework.kafka.listener.ContainerAwareErrorHandler;
import org.springframework.kafka.listener.ContainerProperties;
import org.springframework.kafka.listener.FailedRecordProcessor;
import org.springframework.kafka.listener.LoggingCommitCallback;
import org.springframework.kafka.listener.MessageListenerContainer;
import org.springframework.kafka.support.SeekUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.backoff.BackOff;

public class SeekToCurrentErrorHandler
extends FailedRecordProcessor
implements ContainerAwareErrorHandler {
    private static final LoggingCommitCallback LOGGING_COMMIT_CALLBACK = new LoggingCommitCallback();

    public SeekToCurrentErrorHandler() {
        this(null, (BackOff)SeekUtils.DEFAULT_BACK_OFF);
    }

    @Deprecated
    public SeekToCurrentErrorHandler(int maxFailures) {
        this(null, maxFailures);
    }

    public SeekToCurrentErrorHandler(BackOff backOff) {
        this(null, backOff);
    }

    public SeekToCurrentErrorHandler(BiConsumer<ConsumerRecord<?, ?>, Exception> recoverer) {
        this(recoverer, (BackOff)SeekUtils.DEFAULT_BACK_OFF);
    }

    @Deprecated
    public SeekToCurrentErrorHandler(@Nullable BiConsumer<ConsumerRecord<?, ?>, Exception> recoverer, int maxFailures) {
        super(recoverer, maxFailures);
    }

    public SeekToCurrentErrorHandler(@Nullable BiConsumer<ConsumerRecord<?, ?>, Exception> recoverer, BackOff backOff) {
        super(recoverer, backOff);
    }

    @Override
    public void setCommitRecovered(boolean commitRecovered) {
        super.setCommitRecovered(commitRecovered);
    }

    @Override
    @Deprecated
    public void setClassifier(BinaryExceptionClassifier classifier) {
        Assert.notNull((Object)classifier, (String)"'classifier' + cannot be null");
        classifier.setTraverseCauses(true);
        super.setClassifier(classifier);
    }

    @Override
    public void handle(Exception thrownException, List<ConsumerRecord<?, ?>> records, Consumer<?, ?> consumer, MessageListenerContainer container) {
        if (!SeekUtils.doSeeks(records, consumer, thrownException, true, this.getSkipPredicate(records, thrownException), LOGGER)) {
            throw new KafkaException("Seek to current after exception", thrownException);
        }
        if (this.isCommitRecovered()) {
            if (container.getContainerProperties().getAckMode().equals((Object)ContainerProperties.AckMode.MANUAL_IMMEDIATE)) {
                ConsumerRecord<?, ?> record = records.get(0);
                Map<TopicPartition, OffsetAndMetadata> offsetToCommit = Collections.singletonMap(new TopicPartition(record.topic(), record.partition()), new OffsetAndMetadata(record.offset() + 1L));
                if (container.getContainerProperties().isSyncCommits()) {
                    consumer.commitSync(offsetToCommit, container.getContainerProperties().getSyncCommitTimeout());
                } else {
                    OffsetCommitCallback commitCallback = container.getContainerProperties().getCommitCallback();
                    if (commitCallback == null) {
                        commitCallback = LOGGING_COMMIT_CALLBACK;
                    }
                    consumer.commitAsync(offsetToCommit, commitCallback);
                }
            } else {
                LOGGER.warn(() -> "'commitRecovered' ignored, container AckMode must be MANUAL_IMMEDIATE, not " + (Object)((Object)container.getContainerProperties().getAckMode()));
            }
        }
    }
}

