/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.retrytopic;

import java.util.Arrays;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.springframework.classify.BinaryExceptionClassifier;
import org.springframework.kafka.core.KafkaOperations;
import org.springframework.kafka.retrytopic.DestinationTopic;
import org.springframework.kafka.retrytopic.DltStrategy;
import org.springframework.kafka.retrytopic.FixedDelayStrategy;
import org.springframework.kafka.retrytopic.SameIntervalTopicReuseStrategy;
import org.springframework.kafka.retrytopic.TopicSuffixingStrategy;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;

public class DestinationTopicPropertiesFactory {
    private static final String DEPRECATION = "deprecation";
    private static final String MAIN_TOPIC_SUFFIX = "";
    private final DestinationTopicSuffixes destinationTopicSuffixes;
    private final List<Long> backOffValues;
    private final BinaryExceptionClassifier exceptionClassifier;
    private final int numPartitions;
    private final int maxAttempts;
    private final KafkaOperations<?, ?> kafkaOperations;
    private final FixedDelayStrategy fixedDelayStrategy;
    private final DltStrategy dltStrategy;
    private final TopicSuffixingStrategy topicSuffixingStrategy;
    private final SameIntervalTopicReuseStrategy sameIntervalTopicReuseStrategy;
    private final long timeout;
    @Nullable
    private Boolean autoStartDltHandler;

    public DestinationTopicPropertiesFactory(String retryTopicSuffix, String dltSuffix, List<Long> backOffValues, BinaryExceptionClassifier exceptionClassifier, int numPartitions, KafkaOperations<?, ?> kafkaOperations, DltStrategy dltStrategy, TopicSuffixingStrategy topicSuffixingStrategy, SameIntervalTopicReuseStrategy sameIntervalTopicReuseStrategy, long timeout) {
        this(retryTopicSuffix, dltSuffix, backOffValues, exceptionClassifier, numPartitions, kafkaOperations, FixedDelayStrategy.SINGLE_TOPIC, dltStrategy, topicSuffixingStrategy, sameIntervalTopicReuseStrategy, timeout);
    }

    @Deprecated
    public DestinationTopicPropertiesFactory(String retryTopicSuffix, String dltSuffix, List<Long> backOffValues, BinaryExceptionClassifier exceptionClassifier, int numPartitions, KafkaOperations<?, ?> kafkaOperations, FixedDelayStrategy fixedDelayStrategy, DltStrategy dltStrategy, TopicSuffixingStrategy topicSuffixingStrategy, long timeout) {
        this(retryTopicSuffix, dltSuffix, backOffValues, exceptionClassifier, numPartitions, kafkaOperations, fixedDelayStrategy, dltStrategy, topicSuffixingStrategy, SameIntervalTopicReuseStrategy.MULTIPLE_TOPICS, timeout);
    }

    @Deprecated
    public DestinationTopicPropertiesFactory(String retryTopicSuffix, String dltSuffix, List<Long> backOffValues, BinaryExceptionClassifier exceptionClassifier, int numPartitions, KafkaOperations<?, ?> kafkaOperations, FixedDelayStrategy fixedDelayStrategy, DltStrategy dltStrategy, TopicSuffixingStrategy topicSuffixingStrategy, SameIntervalTopicReuseStrategy sameIntervalTopicReuseStrategy, long timeout) {
        this.dltStrategy = dltStrategy;
        this.kafkaOperations = kafkaOperations;
        this.exceptionClassifier = exceptionClassifier;
        this.numPartitions = numPartitions;
        this.fixedDelayStrategy = fixedDelayStrategy;
        this.topicSuffixingStrategy = topicSuffixingStrategy;
        this.sameIntervalTopicReuseStrategy = sameIntervalTopicReuseStrategy;
        this.timeout = timeout;
        this.destinationTopicSuffixes = new DestinationTopicSuffixes(retryTopicSuffix, dltSuffix);
        this.backOffValues = backOffValues;
        this.maxAttempts = this.backOffValues.size() + 1;
    }

    public DestinationTopicPropertiesFactory autoStartDltHandler(@Nullable Boolean autoStart) {
        this.autoStartDltHandler = autoStart;
        return this;
    }

    public List<DestinationTopic.Properties> createProperties() {
        return this.isSingleTopicFixedDelay() ? this.createPropertiesForFixedDelaySingleTopic() : this.createPropertiesForDefaultTopicStrategy();
    }

    private List<DestinationTopic.Properties> createPropertiesForFixedDelaySingleTopic() {
        return this.isNoDltStrategy() ? Arrays.asList(this.createMainTopicProperties(), this.createRetryProperties(1, this.getShouldRetryOn())) : Arrays.asList(this.createMainTopicProperties(), this.createRetryProperties(1, this.getShouldRetryOn()), this.createDltProperties());
    }

    private boolean isSingleTopicFixedDelay() {
        return this.isFixedDelay() && (this.isSingleTopicStrategy() || this.isSingleTopicSameIntervalTopicReuseStrategy());
    }

    private boolean isSingleTopicStrategy() {
        return FixedDelayStrategy.SINGLE_TOPIC.equals((Object)this.fixedDelayStrategy);
    }

    private boolean isSingleTopicSameIntervalTopicReuseStrategy() {
        return SameIntervalTopicReuseStrategy.SINGLE_TOPIC.equals((Object)this.sameIntervalTopicReuseStrategy);
    }

    private List<DestinationTopic.Properties> createPropertiesForDefaultTopicStrategy() {
        int retryTopicsAmount = this.retryTopicsAmount();
        return IntStream.rangeClosed(0, this.isNoDltStrategy() ? retryTopicsAmount : retryTopicsAmount + 1).mapToObj(this::createTopicProperties).collect(Collectors.toList());
    }

    int retryTopicsAmount() {
        return this.backOffValues.size() - this.reusableTopicAttempts();
    }

    private int reusableTopicAttempts() {
        return this.backOffValues.size() > 0 ? (!this.isFixedDelay() ? (this.isSingleTopicSameIntervalTopicReuseStrategy() ? this.amountOfDuplicates(this.backOffValues.get(this.backOffValues.size() - 1)) - 1 : 0) : (this.isSingleTopicStrategy() ? this.backOffValues.size() - 1 : 0)) : 0;
    }

    private boolean isNoDltStrategy() {
        return DltStrategy.NO_DLT.equals((Object)this.dltStrategy);
    }

    private DestinationTopic.Properties createTopicProperties(int index) {
        BiPredicate<Integer, Throwable> shouldRetryOn = this.getShouldRetryOn();
        return index == 0 ? this.createMainTopicProperties() : (index <= this.retryTopicsAmount() ? this.createRetryProperties(index, shouldRetryOn) : this.createDltProperties());
    }

    private DestinationTopic.Properties createMainTopicProperties() {
        return new DestinationTopic.Properties(0L, MAIN_TOPIC_SUFFIX, DestinationTopic.Type.MAIN, this.maxAttempts, this.numPartitions, this.dltStrategy, this.kafkaOperations, this.getShouldRetryOn(), this.timeout);
    }

    private DestinationTopic.Properties createDltProperties() {
        return new DestinationTopic.Properties(0L, this.destinationTopicSuffixes.getDltSuffix(), DestinationTopic.Type.DLT, this.maxAttempts, this.numPartitions, this.dltStrategy, this.kafkaOperations, (a, e) -> false, this.timeout, this.autoStartDltHandler);
    }

    private BiPredicate<Integer, Throwable> getShouldRetryOn() {
        return (attempt, throwable) -> attempt < this.maxAttempts && this.exceptionClassifier.classify(throwable) != false;
    }

    private DestinationTopic.Properties createRetryProperties(int index, BiPredicate<Integer, Throwable> shouldRetryOn) {
        int indexInBackoffValues = index - 1;
        Long thisBackOffValue = this.backOffValues.get(indexInBackoffValues);
        DestinationTopic.Type topicTypeToUse = this.isSingleTopicFixedDelay() ? DestinationTopic.Type.SINGLE_TOPIC_RETRY : (this.isDelayWithReusedTopic(thisBackOffValue) ? DestinationTopic.Type.REUSABLE_RETRY_TOPIC : DestinationTopic.Type.RETRY);
        return this.createProperties(topicTypeToUse, shouldRetryOn, indexInBackoffValues, this.getTopicSuffix(indexInBackoffValues, thisBackOffValue));
    }

    private String getTopicSuffix(int indexInBackoffValues, Long thisBackOffValue) {
        return this.isSingleTopicFixedDelay() ? this.destinationTopicSuffixes.getRetrySuffix() : (this.isSuffixWithIndexStrategy() || this.isFixedDelay() ? this.joinWithRetrySuffix(indexInBackoffValues) : (this.hasDuplicates(thisBackOffValue) ? this.joinWithRetrySuffix(thisBackOffValue).concat(this.suffixForRepeatedInterval(indexInBackoffValues, thisBackOffValue)) : this.joinWithRetrySuffix(thisBackOffValue)));
    }

    private String suffixForRepeatedInterval(int indexInBackoffValues, Long thisBackOffValue) {
        return this.isSingleTopicSameIntervalTopicReuseStrategy() ? MAIN_TOPIC_SUFFIX : "-" + this.getIndexInBackoffValues(indexInBackoffValues, thisBackOffValue);
    }

    private boolean isDelayWithReusedTopic(Long backoffValue) {
        return this.isSingleTopicFixedDelay() || this.hasDuplicates(backoffValue) && this.isSingleTopicSameIntervalTopicReuseStrategy();
    }

    private int getIndexInBackoffValues(int indexInBackoffValues, Long thisBackOffValue) {
        return indexInBackoffValues - this.backOffValues.indexOf(thisBackOffValue);
    }

    private boolean isSuffixWithIndexStrategy() {
        return TopicSuffixingStrategy.SUFFIX_WITH_INDEX_VALUE.equals((Object)this.topicSuffixingStrategy);
    }

    private boolean hasDuplicates(Long thisBackOffValue) {
        return this.amountOfDuplicates(thisBackOffValue) > 1;
    }

    private int amountOfDuplicates(Long thisBackOffValue) {
        return Long.valueOf(this.backOffValues.stream().filter(value -> value.equals(thisBackOffValue)).count()).intValue();
    }

    private DestinationTopic.Properties createProperties(DestinationTopic.Type topicType, BiPredicate<Integer, Throwable> shouldRetryOn, int indexInBackoffValues, String suffix) {
        return new DestinationTopic.Properties(this.backOffValues.get(indexInBackoffValues), suffix, topicType, this.maxAttempts, this.numPartitions, this.dltStrategy, this.kafkaOperations, shouldRetryOn, this.timeout);
    }

    private boolean isFixedDelay() {
        return this.backOffValues.size() > 1 && this.backOffValues.stream().distinct().count() == 1L;
    }

    private String joinWithRetrySuffix(long parameter) {
        return String.join((CharSequence)"-", this.destinationTopicSuffixes.getRetrySuffix(), String.valueOf(parameter));
    }

    public static class DestinationTopicSuffixes {
        private final String retryTopicSuffix;
        private final String dltSuffix;

        public DestinationTopicSuffixes(String retryTopicSuffix, String dltSuffix) {
            this.retryTopicSuffix = StringUtils.hasText((String)retryTopicSuffix) ? retryTopicSuffix : "-retry";
            this.dltSuffix = StringUtils.hasText((String)dltSuffix) ? dltSuffix : "-dlt";
        }

        public String getRetrySuffix() {
            return this.retryTopicSuffix;
        }

        public String getDltSuffix() {
            return this.dltSuffix;
        }
    }
}

