/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.support.serializer;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.serialization.Serializer;
import org.springframework.util.Assert;

public class DelegatingByTypeSerializer
implements Serializer<Object> {
    private final Map<Class<?>, Serializer<?>> delegates = new LinkedHashMap();
    private final boolean assignable;

    public DelegatingByTypeSerializer(Map<Class<?>, Serializer<?>> delegates) {
        this(delegates, false);
    }

    public DelegatingByTypeSerializer(Map<Class<?>, Serializer<?>> delegates, boolean assignable) {
        Assert.notNull(delegates, (String)"'delegates' cannot be null");
        Assert.noNullElements(delegates.values(), (String)"Serializers in delegates map cannot be null");
        this.delegates.putAll(delegates);
        this.assignable = assignable;
    }

    protected boolean isAssignable() {
        return this.assignable;
    }

    public void configure(Map<String, ?> configs, boolean isKey) {
        this.delegates.values().forEach(del -> del.configure(configs, isKey));
    }

    public byte[] serialize(String topic, Object data) {
        if (data == null) {
            return null;
        }
        Serializer<Object> delegate = this.findDelegate(data, this.delegates);
        return delegate.serialize(topic, data);
    }

    public byte[] serialize(String topic, Headers headers, Object data) {
        if (data == null) {
            return null;
        }
        Serializer<Object> delegate = this.findDelegate(data, this.delegates);
        return delegate.serialize(topic, headers, data);
    }

    protected <T> Serializer<T> findDelegate(T data, Map<Class<?>, Serializer<?>> delegates) {
        if (!this.assignable) {
            Serializer<?> delegate = delegates.get(data.getClass());
            if (delegate == null) {
                throw new SerializationException("No matching delegate for type: " + data.getClass().getName() + "; supported types: " + this.delegates.keySet().stream().map(Class::getName).collect(Collectors.toList()));
            }
            return delegate;
        }
        for (Map.Entry<Class<?>, Serializer<?>> entry : this.delegates.entrySet()) {
            if (!entry.getKey().isAssignableFrom(data.getClass())) continue;
            return entry.getValue();
        }
        throw new SerializationException("No matching delegate for type: " + data.getClass().getName() + "; supported types: " + this.delegates.keySet().stream().map(Class::getName).collect(Collectors.toList()));
    }
}

