/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.core;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.common.serialization.Deserializer;
import org.springframework.kafka.core.ConsumerPostProcessor;
import org.springframework.lang.Nullable;

public interface ConsumerFactory<K, V> {
    default public Consumer<K, V> createConsumer() {
        return this.createConsumer(null);
    }

    default public Consumer<K, V> createConsumer(@Nullable String clientIdSuffix) {
        return this.createConsumer(null, clientIdSuffix);
    }

    default public Consumer<K, V> createConsumer(@Nullable String groupId, @Nullable String clientIdSuffix) {
        return this.createConsumer(groupId, null, clientIdSuffix);
    }

    default public Consumer<K, V> createConsumer(@Nullable String groupId, @Nullable String clientIdPrefix, @Nullable String clientIdSuffix) {
        return this.createConsumer(groupId, clientIdPrefix, clientIdSuffix, null);
    }

    public Consumer<K, V> createConsumer(@Nullable String var1, @Nullable String var2, @Nullable String var3, @Nullable Properties var4);

    public boolean isAutoCommit();

    default public Map<String, Object> getConfigurationProperties() {
        throw new UnsupportedOperationException("'getConfigurationProperties()' is not supported");
    }

    @Nullable
    default public Deserializer<K> getKeyDeserializer() {
        return null;
    }

    @Nullable
    default public Deserializer<V> getValueDeserializer() {
        return null;
    }

    default public boolean removeListener(Listener<K, V> listener) {
        return false;
    }

    default public void addListener(int index, Listener<K, V> listener) {
    }

    default public void addListener(Listener<K, V> listener) {
    }

    default public List<Listener<K, V>> getListeners() {
        return Collections.emptyList();
    }

    default public void addPostProcessor(ConsumerPostProcessor<K, V> postProcessor) {
    }

    default public boolean removePostProcessor(ConsumerPostProcessor<K, V> postProcessor) {
        return false;
    }

    default public List<ConsumerPostProcessor<K, V>> getPostProcessors() {
        return Collections.emptyList();
    }

    default public void updateConfigs(Map<String, Object> updates) {
    }

    default public void removeConfig(String configKey) {
    }

    public static interface Listener<K, V> {
        default public void consumerAdded(String id, Consumer<K, V> consumer) {
        }

        default public void consumerRemoved(String id, Consumer<K, V> consumer) {
        }
    }
}

