/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.support.converter;

import java.util.Map;
import org.apache.kafka.clients.consumer.Consumer;
import org.jspecify.annotations.Nullable;
import org.springframework.kafka.support.Acknowledgment;
import org.springframework.kafka.support.JavaUtils;
import org.springframework.kafka.support.KafkaUtils;

public interface MessageConverter {
    public static @Nullable String getGroupId() {
        return KafkaUtils.getConsumerGroupId();
    }

    default public void commonHeaders(@Nullable Acknowledgment acknowledgment, @Nullable Consumer<?, ?> consumer, Map<String, Object> rawHeaders, @Nullable Object theKey, Object topic, Object partition, Object offset, @Nullable Object timestampType, Object timestamp) {
        rawHeaders.put("kafka_receivedTopic", topic);
        rawHeaders.put("kafka_receivedPartitionId", partition);
        rawHeaders.put("kafka_offset", offset);
        rawHeaders.put("kafka_timestampType", timestampType);
        rawHeaders.put("kafka_receivedTimestamp", timestamp);
        JavaUtils.INSTANCE.acceptIfNotNull("kafka_receivedMessageKey", theKey, (key, val) -> rawHeaders.put((String)key, val)).acceptIfNotNull("kafka_groupId", MessageConverter.getGroupId(), (key, val) -> rawHeaders.put((String)key, val)).acceptIfNotNull("kafka_acknowledgment", acknowledgment, (key, val) -> rawHeaders.put((String)key, val)).acceptIfNotNull("kafka_consumer", consumer, (key, val) -> rawHeaders.put((String)key, val));
    }
}

