/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.event;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.common.TopicPartition;
import org.jspecify.annotations.Nullable;
import org.springframework.kafka.event.KafkaEvent;

public class ListenerContainerIdleEvent
extends KafkaEvent {
    private static final long serialVersionUID = 1L;
    private final long idleTime;
    private final String listenerId;
    private final boolean paused;
    private final transient @Nullable List<TopicPartition> topicPartitions;
    private final transient Consumer<?, ?> consumer;

    public ListenerContainerIdleEvent(Object source, Object container, long idleTime, String id, @Nullable Collection<TopicPartition> topicPartitions, Consumer<?, ?> consumer, boolean paused) {
        super(source, container);
        this.idleTime = idleTime;
        this.listenerId = id;
        this.topicPartitions = topicPartitions == null ? null : new ArrayList<TopicPartition>(topicPartitions);
        this.consumer = consumer;
        this.paused = paused;
    }

    public long getIdleTime() {
        return this.idleTime;
    }

    public @Nullable Collection<TopicPartition> getTopicPartitions() {
        return this.topicPartitions == null ? null : Collections.unmodifiableList(this.topicPartitions);
    }

    public String getListenerId() {
        return this.listenerId;
    }

    public Consumer<?, ?> getConsumer() {
        return this.consumer;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public String toString() {
        return "ListenerContainerIdleEvent [idleTime=" + (float)this.idleTime / 1000.0f + "s, listenerId=" + this.listenerId + ", container=" + String.valueOf(this.getSource()) + ", paused=" + this.paused + ", topicPartitions=" + String.valueOf(this.topicPartitions) + "]";
    }
}

