/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.modulith.aptk.tools;

import java.lang.annotation.Annotation;
import java.lang.annotation.Repeatable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import org.springframework.modulith.aptk.tools.AnnotationValueUtils;
import org.springframework.modulith.aptk.tools.ProcessingEnvironmentUtils;
import org.springframework.modulith.aptk.tools.TypeUtils;

public final class AnnotationUtils {
    private AnnotationUtils() {
    }

    public static AnnotationValue getAnnotationValueOfAttribute(AnnotationMirror annotationMirror) {
        return AnnotationUtils.getAnnotationValueOfAttribute(annotationMirror, "value");
    }

    public static AnnotationValue getAnnotationValueOfAttribute(AnnotationMirror annotationMirror, String key) {
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
            if (!entry.getKey().getSimpleName().toString().equals(key)) continue;
            return entry.getValue();
        }
        return null;
    }

    public static AnnotationValue getAnnotationValueOfAttributeWithDefaults(AnnotationMirror annotationMirror) {
        return AnnotationUtils.getAnnotationValueOfAttributeWithDefaults(annotationMirror, "value");
    }

    public static String[] getMandatoryAttributeValueNames(AnnotationMirror annotationMirror) {
        ArrayList<String> result = new ArrayList<String>();
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : ProcessingEnvironmentUtils.getElements().getElementValuesWithDefaults(annotationMirror).entrySet()) {
            if (entry.getKey().getDefaultValue() != null) continue;
            result.add(entry.getKey().getSimpleName().toString());
        }
        return result.toArray(new String[0]);
    }

    public static String[] getOptionalAttributeValueNames(AnnotationMirror annotationMirror) {
        ArrayList<String> result = new ArrayList<String>();
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : ProcessingEnvironmentUtils.getElements().getElementValuesWithDefaults(annotationMirror).entrySet()) {
            if (entry.getKey().getDefaultValue() == null) continue;
            result.add(entry.getKey().getSimpleName().toString());
        }
        return result.toArray(new String[result.size()]);
    }

    public static AnnotationValue getAnnotationValueOfAttributeWithDefaults(AnnotationMirror annotationMirror, String key) {
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : ProcessingEnvironmentUtils.getElements().getElementValuesWithDefaults(annotationMirror).entrySet()) {
            if (!entry.getKey().getSimpleName().toString().equals(key)) continue;
            return entry.getValue();
        }
        return null;
    }

    public static ExecutableElement getExecutableElementForAnnotationAttributeName(AnnotationMirror annotationMirror, String key) {
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : ProcessingEnvironmentUtils.getElements().getElementValuesWithDefaults(annotationMirror).entrySet()) {
            if (!entry.getKey().getSimpleName().toString().equals(key)) continue;
            return entry.getKey();
        }
        return null;
    }

    public static String getClassAttributeFromAnnotationAsFqn(Element element, Class<? extends Annotation> annotationType) {
        return AnnotationUtils.getClassAttributeFromAnnotationAsFqn(element, annotationType, "value");
    }

    public static String getClassAttributeFromAnnotationAsFqn(Element element, Class<? extends Annotation> annotationType, String attributeName) {
        TypeMirror typeMirror = AnnotationUtils.getClassAttributeFromAnnotationAsTypeMirror(element, annotationType, attributeName);
        return typeMirror != null ? typeMirror.toString() : null;
    }

    public static String getClassAttributeFromAnnotationAsFqn(AnnotationMirror annotationMirror, String attributeName) {
        TypeMirror typeMirror = AnnotationUtils.getClassAttributeFromAnnotationAsTypeMirror(annotationMirror, attributeName);
        return typeMirror != null ? typeMirror.toString() : null;
    }

    public static String getClassAttributeFromAnnotationAsFqn(AnnotationMirror annotationMirror) {
        TypeMirror typeMirror = AnnotationUtils.getClassAttributeFromAnnotationAsTypeMirror(annotationMirror, "value");
        return typeMirror != null ? typeMirror.toString() : null;
    }

    public static TypeMirror getClassAttributeFromAnnotationAsTypeMirror(Element element, Class<? extends Annotation> annotationType) {
        return AnnotationUtils.getClassAttributeFromAnnotationAsTypeMirror(element, annotationType, "value");
    }

    public static TypeMirror getClassAttributeFromAnnotationAsTypeMirror(Element element, Class<? extends Annotation> annotationType, String attributeName) {
        AnnotationMirror annotationMirror = AnnotationUtils.getAnnotationMirror(element, annotationType);
        return AnnotationUtils.getClassAttributeFromAnnotationAsTypeMirror(annotationMirror, attributeName);
    }

    public static TypeMirror getClassAttributeFromAnnotationAsTypeMirror(AnnotationMirror annotationMirror, String attributeName) {
        if (annotationMirror == null) {
            return null;
        }
        AnnotationValue annotationAttributeValue = AnnotationUtils.getAnnotationValueOfAttribute(annotationMirror, attributeName);
        if (annotationAttributeValue == null) {
            return null;
        }
        try {
            return (TypeMirror)annotationAttributeValue.getValue();
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    public static AnnotationMirror getAnnotationMirror(Element element, Class<? extends Annotation> clazz) {
        return AnnotationUtils.getAnnotationMirror(element, clazz.getCanonicalName());
    }

    public static AnnotationMirror getAnnotationMirror(Element element, String fqClassName) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            if (!annotationMirror.getAnnotationType().toString().equals(fqClassName)) continue;
            return annotationMirror;
        }
        return null;
    }

    public static Element getElementForAnnotationMirror(AnnotationMirror annotationMirror) {
        return annotationMirror != null ? annotationMirror.getAnnotationType().asElement() : null;
    }

    public static String[] getClassArrayAttributeFromAnnotationAsFqn(Element element, Class<? extends Annotation> annotationType) {
        return AnnotationUtils.getClassArrayAttributeFromAnnotationAsFqn(element, annotationType, "value");
    }

    public static String[] getClassArrayAttributeFromAnnotationAsFqn(Element element, Class<? extends Annotation> annotationType, String attributeName) {
        AnnotationMirror annotationMirror = AnnotationUtils.getAnnotationMirror(element, annotationType);
        return AnnotationUtils.getClassArrayAttributeFromAnnotationAsFqn(annotationMirror, attributeName);
    }

    public static String[] getClassArrayAttributeFromAnnotationAsFqn(AnnotationMirror annotationMirror, String attributeName) {
        TypeMirror[] typeMirrorArray = AnnotationUtils.getClassArrayAttributeFromAnnotationAsTypeMirror(annotationMirror, attributeName);
        String[] result = null;
        if (typeMirrorArray != null) {
            result = new String[typeMirrorArray.length];
            for (int i = 0; i < typeMirrorArray.length; ++i) {
                result[i] = typeMirrorArray[i].toString();
            }
        }
        return result;
    }

    public static TypeMirror[] getClassArrayAttributeFromAnnotationAsTypeMirror(Element element, Class<? extends Annotation> annotationType) {
        return AnnotationUtils.getClassArrayAttributeFromAnnotationAsTypeMirror(element, annotationType, "value");
    }

    public static TypeMirror[] getClassArrayAttributeFromAnnotationAsTypeMirror(Element element, Class<? extends Annotation> annotationType, String attributeName) {
        AnnotationMirror annotationMirror = AnnotationUtils.getAnnotationMirror(element, annotationType);
        return AnnotationUtils.getClassArrayAttributeFromAnnotationAsTypeMirror(annotationMirror, attributeName);
    }

    public static TypeMirror[] getClassArrayAttributeFromAnnotationAsTypeMirror(AnnotationMirror annotationMirror, String attributeName) {
        if (annotationMirror == null) {
            return null;
        }
        AnnotationValue annotationAttributeValue = AnnotationUtils.getAnnotationValueOfAttribute(annotationMirror, attributeName);
        if (annotationAttributeValue == null) {
            return new TypeMirror[0];
        }
        return AnnotationValueUtils.getTypeAttributeValueArray(annotationAttributeValue);
    }

    public static boolean isRepeatableAnnotation(Class<? extends Annotation> annotation) {
        return annotation != null && TypeUtils.TypeRetrieval.getTypeElement(annotation).getAnnotation(Repeatable.class) != null;
    }

    public static Optional<Class<? extends Annotation>> getRepeatableAnnotationWrapperClass(Class<? extends Annotation> annotation) {
        if (AnnotationUtils.isRepeatableAnnotation(annotation)) {
            TypeElement annotationTypeElement = TypeUtils.TypeRetrieval.getTypeElement(annotation);
            AnnotationMirror annotationMirror = AnnotationUtils.getAnnotationMirror((Element)annotationTypeElement, Repeatable.class);
            TypeMirror typeMirror = AnnotationUtils.getClassAttributeFromAnnotationAsTypeMirror(annotationMirror, "value");
            try {
                return Optional.of(Class.forName(typeMirror.toString()));
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return Optional.empty();
    }

    public static Optional<List<AnnotationMirror>> getRepeatableAnnotation(Element element, Class<? extends Annotation> annotation) {
        AnnotationMirror repeatableAnnotationMirror;
        if (element == null || !AnnotationUtils.isRepeatableAnnotation(annotation)) {
            return Optional.empty();
        }
        Class<? extends Annotation> repeatableAnnotationWrapperType = AnnotationUtils.getRepeatableAnnotationWrapperClass(annotation).get();
        ArrayList<AnnotationMirror> result = new ArrayList<AnnotationMirror>();
        AnnotationMirror singleUse = AnnotationUtils.getAnnotationMirror(element, annotation);
        if (singleUse != null) {
            result.add(singleUse);
        }
        if ((repeatableAnnotationMirror = AnnotationUtils.getAnnotationMirror(element, repeatableAnnotationWrapperType)) != null) {
            AnnotationValue annotationValue = AnnotationUtils.getAnnotationValueOfAttributeWithDefaults(AnnotationUtils.getAnnotationMirror(element, repeatableAnnotationWrapperType));
            result.addAll(Arrays.asList(AnnotationValueUtils.getAnnotationValueArray(annotationValue)));
        }
        return Optional.of(result);
    }
}

