/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.modulith.aptk.tools.matcher.impl;

import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import org.springframework.modulith.aptk.tools.AnnotationUtils;
import org.springframework.modulith.aptk.tools.TypeUtils;
import org.springframework.modulith.aptk.tools.corematcher.AptkCoreMatchers;
import org.springframework.modulith.aptk.tools.fluentfilter.FluentElementFilter;
import org.springframework.modulith.aptk.tools.matcher.ImplicitMatcher;

public class HasPublicNoargConstructorMatcher
implements ImplicitMatcher<Element> {
    @Override
    public boolean check(Element element) {
        if (element == null) {
            return false;
        }
        TypeElement typeElement = TypeUtils.TypeRetrieval.getTypeElement(element.asType());
        if (typeElement == null) {
            return false;
        }
        FluentElementFilter<ExecutableElement> fluentElementFilter = FluentElementFilter.createFluentElementFilter(element.getEnclosedElements()).applyFilter(AptkCoreMatchers.IS_CONSTRUCTOR);
        boolean hasLombokNoArgConstructor = AnnotationUtils.getAnnotationMirror((Element)typeElement, "lombok.NoArgsConstructor") != null;
        boolean hasLombokAllArgsConstructor = AnnotationUtils.getAnnotationMirror((Element)typeElement, "lombok.AllArgsConstructor") != null;
        boolean hasLombokRequiredArgsConstructor = AnnotationUtils.getAnnotationMirror((Element)typeElement, "lombok.RequiredArgsConstructor") != null;
        return fluentElementFilter.isEmpty() && !hasLombokAllArgsConstructor && !hasLombokRequiredArgsConstructor || hasLombokNoArgConstructor || fluentElementFilter.applyFilter(AptkCoreMatchers.HAS_NO_PARAMETERS).applyFilter(AptkCoreMatchers.BY_MODIFIER).filterByOneOf((Modifier[])new Modifier[]{Modifier.PUBLIC}).hasSingleElement();
    }
}

