/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.modulith.aptk.tools.wrapper;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.Name;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import org.springframework.modulith.aptk.tools.wrapper.ElementWrapper;
import org.springframework.modulith.aptk.tools.wrapper.PackageElementWrapper;
import org.springframework.modulith.aptk.tools.wrapper.TypeElementWrapper;

public class ModuleElementWrapper
extends ElementWrapper<Element> {
    private static final String MODULE_ELEMENT_CLASS_NAME = "javax.lang.model.element.ModuleElement";
    private static final String DIRECTIVE_CLASS_NAME = "javax.lang.model.element.ModuleElement$Directive";
    private static final String EXPORTS_DIRECTIVE_CLASS_NAME = "javax.lang.model.element.ModuleElement$ExportsDirective";
    private static final String PROVIDES_DIRECTIVE_CLASS_NAME = "javax.lang.model.element.ModuleElement$ProvidesDirective";
    private static final String USES_DIRECTIVE_CLASS_NAME = "javax.lang.model.element.ModuleElement$UsesDirective";
    private static final String OPENS_DIRECTIVE_CLASS_NAME = "javax.lang.model.element.ModuleElement$OpensDirective";
    private static final String REQUIRES_DIRECTIVE_CLASS_NAME = "javax.lang.model.element.ModuleElement$RequiresDirective";

    private static Directive createDirective(Object instance) {
        if (instance == null) {
            return null;
        }
        if (Directive.isExportDirective(instance)) {
            return new ExportsDirectiveImpl(instance);
        }
        if (Directive.isOpensDirective(instance)) {
            return new OpensDirectiveImpl(instance);
        }
        if (Directive.isProvidesDirective(instance)) {
            return new ProvidesDirectiveImpl(instance);
        }
        if (Directive.isRequiresDirective(instance)) {
            return new RequiresDirectiveImpl(instance);
        }
        if (Directive.isUsesDirective(instance)) {
            return new UsesDirectiveImpl(instance);
        }
        return null;
    }

    private static List<Directive> createDirectives(List<?> directives) {
        return directives.stream().map(e -> ModuleElementWrapper.createDirective(e)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private ModuleElementWrapper(Element moduleElement) {
        super(moduleElement);
    }

    public String getQualifiedName() {
        return ((Name)this.invokeParameterlessMethodOfElement(MODULE_ELEMENT_CLASS_NAME, "getQualifiedName")).toString();
    }

    public boolean hasQualifiedName(String name) {
        return name != null && this.getQualifiedName().equals(name);
    }

    public boolean isOpen() {
        return (Boolean)this.invokeParameterlessMethodOfElement(MODULE_ELEMENT_CLASS_NAME, "isOpen");
    }

    public boolean isUnnamed() {
        return (Boolean)this.invokeParameterlessMethodOfElement(MODULE_ELEMENT_CLASS_NAME, "isUnnamed");
    }

    public List<Directive> getDirectives() {
        return ModuleElementWrapper.createDirectives((List)this.invokeParameterlessMethodOfElement(MODULE_ELEMENT_CLASS_NAME, "getDirectives"));
    }

    public static ModuleElementWrapper toModuleElement(ElementWrapper<?> element) {
        return ModuleElementWrapper.wrap(element.unwrap());
    }

    public static ModuleElementWrapper wrap(Element element) {
        return element == null || !"MODULE".equals(element.getKind().name()) ? null : new ModuleElementWrapper(element);
    }

    public static List<ModuleElementWrapper> wrapList(List<Element> moduleElements) {
        return moduleElements.stream().map(ModuleElementWrapper::wrap).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static abstract class Directive {
        protected final Object wrappedDirective;

        private Directive(Object wrappedDirective) {
            this.wrappedDirective = wrappedDirective;
        }

        public boolean isExportDirective() {
            return Directive.isExportDirective(this.wrappedDirective);
        }

        private static boolean isExportDirective(Object instance) {
            return "EXPORTS".equals(ElementWrapper.invokeParameterlessMethodOfElement(instance, ModuleElementWrapper.DIRECTIVE_CLASS_NAME, "getKind").toString());
        }

        public ExportsDirective toExportsDirective() {
            return (ExportsDirective)((Object)this);
        }

        public boolean isOpensDirective() {
            return Directive.isOpensDirective(this.wrappedDirective);
        }

        private static boolean isOpensDirective(Object instance) {
            return "OPENS".equals(ElementWrapper.invokeParameterlessMethodOfElement(instance, ModuleElementWrapper.DIRECTIVE_CLASS_NAME, "getKind").toString());
        }

        public OpensDirective toOpensDirective() {
            return (OpensDirective)((Object)this);
        }

        public boolean isProvidesDirective() {
            return Directive.isProvidesDirective(this.wrappedDirective);
        }

        private static boolean isProvidesDirective(Object instance) {
            return "PROVIDES".equals(ElementWrapper.invokeParameterlessMethodOfElement(instance, ModuleElementWrapper.DIRECTIVE_CLASS_NAME, "getKind").toString());
        }

        public ProvidesDirective toProvidesDirective() {
            return (ProvidesDirective)((Object)this);
        }

        public boolean isRequiresDirective() {
            return Directive.isRequiresDirective(this.wrappedDirective);
        }

        private static boolean isRequiresDirective(Object instance) {
            return "REQUIRES".equals(ElementWrapper.invokeParameterlessMethodOfElement(instance, ModuleElementWrapper.DIRECTIVE_CLASS_NAME, "getKind").toString());
        }

        public RequiresDirective toRequiresDirective() {
            return (RequiresDirective)((Object)this);
        }

        public boolean isUsesDirective() {
            return Directive.isUsesDirective(this.wrappedDirective);
        }

        private static boolean isUsesDirective(Object instance) {
            return "USES".equals(ElementWrapper.invokeParameterlessMethodOfElement(instance, ModuleElementWrapper.DIRECTIVE_CLASS_NAME, "getKind").toString());
        }

        public UsesDirective toUsesDirective() {
            return (UsesDirective)((Object)this);
        }
    }

    static class ExportsDirectiveImpl
    extends Directive
    implements ExportsDirective {
        private ExportsDirectiveImpl(Object wrappedDirective) {
            super(wrappedDirective);
        }

        @Override
        public PackageElementWrapper getPackage() {
            return PackageElementWrapper.wrap((PackageElement)ElementWrapper.invokeParameterlessMethodOfElement(this.wrappedDirective, ModuleElementWrapper.EXPORTS_DIRECTIVE_CLASS_NAME, "getPackage"));
        }

        @Override
        public List<ModuleElementWrapper> getTargetModules() {
            return ModuleElementWrapper.wrapList((List)ElementWrapper.invokeParameterlessMethodOfElement(this.wrappedDirective, ModuleElementWrapper.EXPORTS_DIRECTIVE_CLASS_NAME, "getTargetModules"));
        }
    }

    static class OpensDirectiveImpl
    extends Directive
    implements OpensDirective {
        private OpensDirectiveImpl(Object wrappedDirective) {
            super(wrappedDirective);
        }

        @Override
        public PackageElementWrapper getPackage() {
            return PackageElementWrapper.wrap((PackageElement)ElementWrapper.invokeParameterlessMethodOfElement(this.wrappedDirective, ModuleElementWrapper.OPENS_DIRECTIVE_CLASS_NAME, "getPackage"));
        }

        @Override
        public List<ModuleElementWrapper> getTargetModules() {
            return ModuleElementWrapper.wrapList((List)ElementWrapper.invokeParameterlessMethodOfElement(this.wrappedDirective, ModuleElementWrapper.OPENS_DIRECTIVE_CLASS_NAME, "getTargetModules"));
        }
    }

    static class ProvidesDirectiveImpl
    extends Directive
    implements ProvidesDirective {
        private ProvidesDirectiveImpl(Object wrappedDirective) {
            super(wrappedDirective);
        }

        @Override
        public TypeElementWrapper getService() {
            return TypeElementWrapper.wrap((TypeElement)ElementWrapper.invokeParameterlessMethodOfElement(this.wrappedDirective, ModuleElementWrapper.PROVIDES_DIRECTIVE_CLASS_NAME, "getService"));
        }

        @Override
        public List<TypeElementWrapper> getImplementations() {
            List implementations = (List)ElementWrapper.invokeParameterlessMethodOfElement(this.wrappedDirective, ModuleElementWrapper.PROVIDES_DIRECTIVE_CLASS_NAME, "getImplementations");
            return implementations.stream().map(TypeElementWrapper::wrap).collect(Collectors.toList());
        }
    }

    static class RequiresDirectiveImpl
    extends Directive
    implements RequiresDirective {
        private RequiresDirectiveImpl(Object wrappedDirective) {
            super(wrappedDirective);
        }

        @Override
        public ModuleElementWrapper getDependency() {
            return ModuleElementWrapper.wrap((Element)ElementWrapper.invokeParameterlessMethodOfElement(this.wrappedDirective, ModuleElementWrapper.REQUIRES_DIRECTIVE_CLASS_NAME, "getDependency"));
        }

        @Override
        public boolean isStatic() {
            return (Boolean)ElementWrapper.invokeParameterlessMethodOfElement(this.wrappedDirective, ModuleElementWrapper.REQUIRES_DIRECTIVE_CLASS_NAME, "isStatic");
        }

        @Override
        public boolean isTransitive() {
            return (Boolean)ElementWrapper.invokeParameterlessMethodOfElement(this.wrappedDirective, ModuleElementWrapper.REQUIRES_DIRECTIVE_CLASS_NAME, "isTransitive");
        }
    }

    public static class UsesDirectiveImpl
    extends Directive
    implements UsesDirective {
        private UsesDirectiveImpl(Object wrappedDirective) {
            super(wrappedDirective);
        }

        @Override
        public TypeElementWrapper getService() {
            return TypeElementWrapper.wrap((TypeElement)ElementWrapper.invokeParameterlessMethodOfElement(this.wrappedDirective, ModuleElementWrapper.USES_DIRECTIVE_CLASS_NAME, "getService"));
        }
    }

    public static interface UsesDirective {
        public TypeElementWrapper getService();
    }

    public static interface RequiresDirective {
        public ModuleElementWrapper getDependency();

        public boolean isStatic();

        public boolean isTransitive();
    }

    public static interface ProvidesDirective {
        public TypeElementWrapper getService();

        public List<TypeElementWrapper> getImplementations();
    }

    public static interface OpensDirective {
        public PackageElementWrapper getPackage();

        public List<ModuleElementWrapper> getTargetModules();
    }

    public static interface ExportsDirective {
        public PackageElementWrapper getPackage();

        public List<ModuleElementWrapper> getTargetModules();
    }
}

