/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.modulith.events.jdbc;

import java.util.Collection;
import java.util.List;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.modulith.events.jdbc.DatabaseType;
import org.springframework.modulith.events.jdbc.JdbcRepositorySettings;
import org.springframework.util.Assert;

public class DatabaseSchemaLocator {
    private final ResourceLoader resourceLoader;

    DatabaseSchemaLocator(ResourceLoader resourceLoader) {
        Assert.notNull((Object)resourceLoader, (String)"ResourceLoader must not be null!");
        this.resourceLoader = resourceLoader;
    }

    Collection<Resource> getSchemaResource(JdbcRepositorySettings settings) {
        Assert.notNull((Object)settings, (String)"JdbcRepositorySettings must not be null!");
        DatabaseType databaseType = settings.getDatabaseType();
        String schemaResourceFilename = databaseType.getSchemaResourceFilename();
        Resource schemaResource = this.resourceLoader.getResource("classpath:" + schemaResourceFilename);
        return !settings.isArchiveCompletion() ? List.of(schemaResource) : List.of(schemaResource, this.resourceLoader.getResource("classpath:" + databaseType.getArchiveSchemaResourceFilename()));
    }
}

