/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.modulith.events.jdbc;

import java.sql.DatabaseMetaData;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ResourceLoader;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.modulith.events.config.EventPublicationAutoConfiguration;
import org.springframework.modulith.events.config.EventPublicationConfigurationExtension;
import org.springframework.modulith.events.core.EventSerializer;
import org.springframework.modulith.events.jdbc.DatabaseSchemaInitializer;
import org.springframework.modulith.events.jdbc.DatabaseType;
import org.springframework.modulith.events.jdbc.JdbcConfigurationProperties;
import org.springframework.modulith.events.jdbc.JdbcEventPublicationRepository;
import org.springframework.modulith.events.jdbc.JdbcRepositorySettings;
import org.springframework.modulith.events.support.CompletionMode;

@Configuration(proxyBeanMethods=false)
@AutoConfigureBefore(value={EventPublicationAutoConfiguration.class})
@EnableConfigurationProperties(value={JdbcConfigurationProperties.class})
class JdbcEventPublicationAutoConfiguration
implements EventPublicationConfigurationExtension {
    @Autowired
    Environment environment;

    JdbcEventPublicationAutoConfiguration() {
    }

    @Bean
    DatabaseType databaseType(DataSource dataSource) {
        return DatabaseType.from(JdbcEventPublicationAutoConfiguration.fromDataSource(dataSource));
    }

    @Bean
    JdbcRepositorySettings jdbcEventPublicationRepositorySettings(DatabaseType databaseType, JdbcConfigurationProperties properties) {
        return new JdbcRepositorySettings(databaseType, CompletionMode.from((Environment)this.environment), properties.getSchema());
    }

    @Bean
    JdbcEventPublicationRepository jdbcEventPublicationRepository(JdbcTemplate jdbcTemplate, EventSerializer serializer, JdbcRepositorySettings settings) {
        return new JdbcEventPublicationRepository((JdbcOperations)jdbcTemplate, serializer, settings);
    }

    @Bean
    @ConditionalOnProperty(name={"spring.modulith.events.jdbc.schema-initialization.enabled"}, havingValue="true")
    DatabaseSchemaInitializer databaseSchemaInitializer(DataSource dataSource, ResourceLoader resourceLoader, DatabaseType databaseType, JdbcTemplate jdbcTemplate, JdbcRepositorySettings settings) {
        return new DatabaseSchemaInitializer(dataSource, resourceLoader, (JdbcOperations)jdbcTemplate, settings);
    }

    private static String fromDataSource(DataSource dataSource) {
        String name = null;
        try {
            String metadata = (String)JdbcUtils.extractDatabaseMetaData((DataSource)dataSource, DatabaseMetaData::getDatabaseProductName);
            name = JdbcUtils.commonDatabaseName((String)metadata);
        }
        catch (Exception o_O) {
            throw new RuntimeException(o_O);
        }
        return name == null ? "UNKNOWN" : name;
    }
}

