/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.modulith.junit.diff;

import java.util.function.Supplier;
import java.util.stream.Stream;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.CanonicalTreeParser;
import org.springframework.modulith.junit.diff.ModifiedFile;
import org.springframework.util.function.ThrowingFunction;
import org.springframework.util.function.ThrowingSupplier;

interface JGitUtil {
    public static <T> T withTry(ThrowingSupplier<T> supplier) {
        try {
            return (T)supplier.get();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <A extends AutoCloseable, T> T withTry(Supplier<A> closable, ThrowingFunction<A, T> supplier) {
        try (AutoCloseable a = (AutoCloseable)closable.get();){
            Object object = supplier.apply((Object)a);
            return (T)object;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T withRepository(ThrowingFunction<Repository, T> function) {
        return JGitUtil.withTry(JGitUtil::buildRepository, function);
    }

    public static Stream<ModifiedFile> toModifiedFiles(Repository repository, String oldRef, String newRef) {
        Stream<ModifiedFile> stream;
        Git git = new Git(repository);
        try {
            AbstractTreeIterator oldTreeParser = JGitUtil.prepareTreeParser(repository, oldRef);
            AbstractTreeIterator newTreeParser = JGitUtil.prepareTreeParser(repository, newRef);
            stream = git.diff().setOldTree(oldTreeParser).setNewTree(newTreeParser).call().stream().flatMap(entry -> ModifiedFile.of(entry.getNewPath(), entry.getOldPath())).distinct().filter(change -> !change.path().equals("/dev/null"));
        }
        catch (Throwable throwable) {
            try {
                try {
                    git.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (GitAPIException e) {
                throw new RuntimeException("Unable to find diff between refs '%s' and '%s'".formatted(oldRef, newRef), e);
            }
        }
        git.close();
        return stream;
    }

    private static Repository buildRepository() {
        return (Repository)JGitUtil.withTry(() -> ((FileRepositoryBuilder)new FileRepositoryBuilder().findGitDir()).build());
    }

    private static AbstractTreeIterator prepareTreeParser(Repository repository, String ref) {
        return (AbstractTreeIterator)JGitUtil.withTry(() -> new RevWalk(repository), walk -> {
            ObjectId commitId = repository.resolve(ref);
            RevCommit commit = walk.parseCommit((AnyObjectId)commitId);
            RevTree tree = walk.parseTree((AnyObjectId)commit.getTree().getId());
            CanonicalTreeParser treeParser = new CanonicalTreeParser();
            try (ObjectReader reader = repository.newObjectReader();){
                treeParser.reset(reader, (AnyObjectId)tree.getId());
            }
            return treeParser;
        });
    }
}

