/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.modulith.junit.diff;

import com.tngtech.archunit.thirdparty.com.google.common.collect.Streams;
import java.util.stream.Stream;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.lib.Repository;
import org.springframework.modulith.junit.diff.FileModificationDetector;
import org.springframework.modulith.junit.diff.JGitUtil;
import org.springframework.modulith.junit.diff.ModifiedFile;

enum UncommittedChangesDetector implements FileModificationDetector
{
    INSTANCE;


    @Override
    public Stream<ModifiedFile> getModifiedFiles() {
        return (Stream)JGitUtil.withRepository(UncommittedChangesDetector::findUncommittedChanges);
    }

    private static Stream<ModifiedFile> findUncommittedChanges(Repository repository) {
        return (Stream)JGitUtil.withTry(() -> new Git(repository), git -> {
            Status status = git.status().call();
            return Streams.concat((Stream[])new Stream[]{status.getUncommittedChanges().stream(), status.getUntracked().stream()}).map(ModifiedFile::new);
        });
    }
}

