/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.modulith.moments;

import java.time.LocalDate;
import java.time.Month;
import java.time.Year;
import java.util.Objects;
import org.jmolecules.event.types.DomainEvent;
import org.springframework.modulith.moments.Quarter;
import org.springframework.modulith.moments.ShiftedQuarter;
import org.springframework.util.Assert;

public class QuarterHasPassed
implements DomainEvent {
    private final Year year;
    private final ShiftedQuarter quarter;

    private QuarterHasPassed(Year year, ShiftedQuarter quarter) {
        Assert.notNull((Object)year, (String)"Year must not be null!");
        Assert.notNull((Object)quarter, (String)"ShiftedQuarter must not be null!");
        this.year = year;
        this.quarter = quarter;
    }

    public static QuarterHasPassed of(Year year, ShiftedQuarter quarter) {
        return new QuarterHasPassed(year, quarter);
    }

    public static QuarterHasPassed of(Year year, Quarter quarter) {
        return QuarterHasPassed.of(year, ShiftedQuarter.of(quarter));
    }

    public static QuarterHasPassed of(Year year, Quarter quarter, Month startMonth) {
        return QuarterHasPassed.of(year, ShiftedQuarter.of(quarter, startMonth));
    }

    public LocalDate getStartDate() {
        return this.quarter.getStartDate(this.year);
    }

    public LocalDate getEndDate() {
        return this.quarter.getEndDate(this.year);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof QuarterHasPassed)) {
            return false;
        }
        QuarterHasPassed that = (QuarterHasPassed)obj;
        return Objects.equals(this.quarter, that.quarter) && Objects.equals(this.year, that.year);
    }

    public int hashCode() {
        return Objects.hash(this.quarter, this.year);
    }
}

