/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.extender.internal.support;

import org.apache.commons.logging.Log;
import org.springframework.osgi.context.event.OsgiBundleApplicationContextEvent;
import org.springframework.osgi.context.event.OsgiBundleApplicationContextListener;
import org.springframework.osgi.context.event.OsgiBundleContextClosedEvent;
import org.springframework.osgi.context.event.OsgiBundleContextFailedEvent;
import org.springframework.osgi.context.event.OsgiBundleContextRefreshedEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultOsgiBundleApplicationContextListener
implements OsgiBundleApplicationContextListener<OsgiBundleApplicationContextEvent> {
    private final Log log;

    public DefaultOsgiBundleApplicationContextListener(Log log) {
        this.log = log;
    }

    public void onOsgiApplicationEvent(OsgiBundleApplicationContextEvent event) {
        String applicationContextString = event.getApplicationContext().getDisplayName();
        if (event instanceof OsgiBundleContextRefreshedEvent) {
            this.log.info((Object)("Application context successfully refreshed (" + applicationContextString + ")"));
        }
        if (event instanceof OsgiBundleContextFailedEvent) {
            OsgiBundleContextFailedEvent failureEvent = (OsgiBundleContextFailedEvent)event;
            this.log.error((Object)("Application context refresh failed (" + applicationContextString + ")"), failureEvent.getFailureCause());
        }
        if (event instanceof OsgiBundleContextClosedEvent) {
            OsgiBundleContextClosedEvent closedEvent = (OsgiBundleContextClosedEvent)event;
            Throwable error = closedEvent.getFailureCause();
            if (error == null) {
                this.log.info((Object)("Application context succesfully closed (" + applicationContextString + ")"));
            } else {
                this.log.error((Object)("Application context close failed (" + applicationContextString + ")"), error);
            }
        }
    }
}

