/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.io.internal.resolver;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.ExportedPackage;
import org.osgi.service.packageadmin.PackageAdmin;
import org.springframework.osgi.io.internal.OsgiHeaderUtils;
import org.springframework.osgi.io.internal.resolver.DependencyResolver;
import org.springframework.osgi.io.internal.resolver.ImportedBundle;
import org.springframework.util.Assert;

public class PackageAdminResolver
implements DependencyResolver {
    private final BundleContext bundleContext;

    public PackageAdminResolver(BundleContext bundleContext) {
        Assert.notNull((Object)bundleContext);
        this.bundleContext = bundleContext;
    }

    public ImportedBundle[] getImportedBundles(Bundle bundle) {
        PackageAdmin pa = this.getPackageAdmin();
        LinkedHashMap importedBundles = new LinkedHashMap(8);
        String[] entries = OsgiHeaderUtils.getRequireBundle(bundle);
        for (int i = 0; i < entries.length; ++i) {
            String[] parsed = OsgiHeaderUtils.parseRequiredBundleString(entries[i]);
            Bundle requiredBundle = pa.getBundles(parsed[0], parsed[1])[0];
            ExportedPackage[] exportedPackages = pa.getExportedPackages(requiredBundle);
            if (exportedPackages == null) continue;
            this.addExportedPackages(importedBundles, requiredBundle, exportedPackages);
        }
        Bundle[] bundles = this.bundleContext.getBundles();
        for (int i = 0; i < bundles.length; ++i) {
            ExportedPackage[] epa;
            Bundle analyzedBundle = bundles[i];
            if (importedBundles.containsKey(analyzedBundle) || (epa = pa.getExportedPackages(analyzedBundle)) == null) continue;
            for (int j = 0; j < epa.length; ++j) {
                ExportedPackage exportedPackage = epa[j];
                Bundle[] importingBundles = exportedPackage.getImportingBundles();
                if (importingBundles == null) continue;
                for (int k = 0; k < importingBundles.length; ++k) {
                    if (!bundle.equals(importingBundles[k])) continue;
                    this.addImportedBundle(importedBundles, exportedPackage.getExportingBundle(), exportedPackage.getName());
                }
            }
        }
        ArrayList<ImportedBundle> importedBundlesList = new ArrayList<ImportedBundle>(importedBundles.size());
        Iterator iterator = importedBundles.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Bundle importedBundle = (Bundle)entry.getKey();
            List packages = (List)entry.getValue();
            importedBundlesList.add(new ImportedBundle(importedBundle, packages.toArray(new String[packages.size()])));
        }
        return importedBundlesList.toArray(new ImportedBundle[importedBundlesList.size()]);
    }

    private void addImportedBundle(Map map, Bundle bundle, String packageName) {
        ArrayList<String> packages = (ArrayList<String>)map.get(bundle);
        if (packages == null) {
            packages = new ArrayList<String>(4);
            map.put(bundle, packages);
        }
        packages.add(packageName);
    }

    private void addExportedPackages(Map map, Bundle bundle, ExportedPackage[] pkgs) {
        ArrayList<String> packages = (ArrayList<String>)map.get(bundle);
        if (packages == null) {
            packages = new ArrayList<String>(pkgs.length);
            map.put(bundle, packages);
        }
        for (int i = 0; i < pkgs.length; ++i) {
            ExportedPackage exportedPackage = pkgs[i];
            packages.add(exportedPackage.getName());
        }
    }

    private PackageAdmin getPackageAdmin() {
        ServiceReference ref = this.bundleContext.getServiceReference(PackageAdmin.class.getName());
        if (ref == null) {
            throw new IllegalStateException(PackageAdmin.class.getName() + " service is required");
        }
        return (PackageAdmin)this.bundleContext.getService(ref);
    }
}

