/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.test;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.osgi.test.AbstractDependencyManagerTests;
import org.springframework.osgi.test.JUnitTestActivator;
import org.springframework.osgi.test.internal.storage.MemoryStorage;
import org.springframework.osgi.test.internal.util.DependencyVisitor;
import org.springframework.osgi.test.internal.util.JarCreator;
import org.springframework.osgi.util.OsgiStringUtils;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public abstract class AbstractOnTheFlyBundleCreatorTests
extends AbstractDependencyManagerTests {
    private static final String META_INF_JAR_LOCATION = "/META-INF/MANIFEST.MF";
    JarCreator jarCreator;
    private Map jarEntries;
    private Manifest manifest;

    public AbstractOnTheFlyBundleCreatorTests() {
        this.initializeJarCreator();
    }

    public AbstractOnTheFlyBundleCreatorTests(String testName) {
        super(testName);
        this.initializeJarCreator();
    }

    private void initializeJarCreator() {
        this.jarCreator = new JarCreator();
        this.jarCreator.setStorage(new MemoryStorage());
    }

    protected String getRootPath() {
        return "file:./target/test-classes/";
    }

    protected String[] getBundleContentPattern() {
        return new String[]{"/**/*"};
    }

    protected String getManifestLocation() {
        return null;
    }

    protected Manifest getManifest() {
        if (this.manifest != null) {
            return this.manifest;
        }
        String manifestLocation = this.getManifestLocation();
        if (StringUtils.hasText((String)manifestLocation)) {
            this.logger.info((Object)("Using Manifest from specified location=[" + this.getManifestLocation() + "]"));
            DefaultResourceLoader loader = new DefaultResourceLoader();
            this.manifest = this.createManifestFrom(loader.getResource(manifestLocation));
        } else {
            this.jarCreator.setRootPath(this.getRootPath());
            this.jarCreator.setContentPattern(this.getBundleContentPattern());
            this.jarEntries = this.jarCreator.resolveContent();
            Iterator iterator = this.jarEntries.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                if (!META_INF_JAR_LOCATION.equals(entry.getKey())) continue;
                this.logger.info((Object)"Using Manifest from the test bundle content=[/META-INF/MANIFEST.MF]");
                this.manifest = this.createManifestFrom((Resource)entry.getValue());
            }
            if (this.manifest == null) {
                this.logger.info((Object)"Automatically creating Manifest for the test bundle");
                this.manifest = this.createDefaultManifest();
            }
        }
        return this.manifest;
    }

    private Manifest createManifestFrom(Resource resource) {
        Assert.notNull((Object)resource);
        try {
            return new Manifest(resource.getInputStream());
        }
        catch (IOException ex) {
            throw (RuntimeException)new IllegalArgumentException("cannot create manifest from " + resource).initCause(ex);
        }
    }

    protected Manifest createDefaultManifest() {
        Manifest manifest = new Manifest();
        Attributes attrs = manifest.getMainAttributes();
        attrs.put(Attributes.Name.MANIFEST_VERSION, "1.0");
        attrs.putValue("Bundle-ManifestVersion", "2");
        String description = this.getName() + "-" + ((Object)((Object)this)).getClass().getName();
        attrs.putValue("Bundle-Name", "TestBundle-" + description);
        attrs.putValue("Bundle-SymbolicName", "TestBundle-" + description);
        attrs.putValue("Bundle-Description", "on-the-fly test bundle");
        attrs.putValue("Bundle-Activator", JUnitTestActivator.class.getName());
        this.addImportPackage(manifest);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Created manifest:" + manifest.getMainAttributes().entrySet()));
        }
        return manifest;
    }

    private void addImportPackage(Manifest manifest) {
        Object[] rawImports = this.determineImports(((Object)((Object)this)).getClass());
        boolean trace = this.logger.isTraceEnabled();
        if (trace) {
            this.logger.trace((Object)("Discovered raw imports " + ObjectUtils.nullSafeToString((Object[])rawImports)));
        }
        Collection specialImportsOut = this.eliminateSpecialPackages((String[])rawImports);
        Collection imports = this.eliminatePackagesAvailableInTheJar(specialImportsOut);
        if (trace) {
            this.logger.trace((Object)("Filtered imports are " + imports));
        }
        manifest.getMainAttributes().putValue("Import-Package", StringUtils.collectionToCommaDelimitedString((Collection)imports));
    }

    private Collection eliminateSpecialPackages(String[] rawImports) {
        String currentPckg = ClassUtils.classPackageAsResourcePath(((Object)((Object)this)).getClass()).replace('/', '.');
        LinkedHashSet<String> filteredImports = new LinkedHashSet<String>(rawImports.length);
        LinkedHashSet<String> eliminatedImports = new LinkedHashSet<String>(4);
        for (int i = 0; i < rawImports.length; ++i) {
            String pckg = rawImports[i];
            if (!(pckg.startsWith("java.") || pckg.startsWith("org.springframework.osgi.test.internal") || pckg.equals(currentPckg))) {
                filteredImports.add(pckg);
                continue;
            }
            eliminatedImports.add(pckg);
        }
        if (!eliminatedImports.isEmpty() && this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Eliminated special packages " + eliminatedImports));
        }
        return filteredImports;
    }

    private Collection eliminatePackagesAvailableInTheJar(Collection imports) {
        if (this.jarEntries == null || this.jarEntries.isEmpty()) {
            return imports;
        }
        LinkedHashSet<String> filteredImports = new LinkedHashSet<String>(imports.size());
        LinkedHashSet<String> eliminatedImports = new LinkedHashSet<String>(2);
        Collection jarPackages = this.jarCreator.getContainedPackages();
        Iterator iterator = imports.iterator();
        while (iterator.hasNext()) {
            String pckg = (String)iterator.next();
            if (jarPackages.contains(pckg)) {
                eliminatedImports.add(pckg);
                continue;
            }
            filteredImports.add(pckg);
        }
        if (!eliminatedImports.isEmpty() && this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Eliminated packages already present in the bundle " + eliminatedImports));
        }
        return filteredImports;
    }

    private String[] determineImports(Class clazz) {
        String clazzPackage;
        Assert.notNull((Object)clazz, (String)"a not-null class is required");
        boolean trace = this.logger.isTraceEnabled();
        String endPackage = ClassUtils.classPackageAsResourcePath((Class)AbstractOnTheFlyBundleCreatorTests.class).replace('/', '.');
        LinkedHashSet<String> cumulatedPackages = new LinkedHashSet<String>();
        Collection containedPackages = this.jarCreator.getContainedPackages();
        boolean validPackageCollection = !containedPackages.isEmpty();
        do {
            clazzPackage = ClassUtils.classPackageAsResourcePath((Class)clazz).replace('/', '.');
            if (validPackageCollection && !containedPackages.contains(clazzPackage)) {
                this.logger.trace((Object)("Package [" + clazzPackage + "] is NOT part of the test archive; adding an import for it"));
                cumulatedPackages.add(clazzPackage);
            } else {
                if (trace) {
                    this.logger.trace((Object)("Package [" + clazzPackage + "] is part of the test archive; parsing " + clazz + " bytecode to determine imports..."));
                }
                cumulatedPackages.addAll(this.determineImportsForClass(clazz));
            }
            clazz = clazz.getSuperclass();
        } while (!endPackage.equals(clazzPackage));
        Object[] packages = cumulatedPackages.toArray(new String[cumulatedPackages.size()]);
        Arrays.sort(packages);
        for (int i = 0; i < packages.length; ++i) {
            packages[i] = ((String)packages[i]).replace('/', '.');
        }
        return packages;
    }

    private Set determineImportsForClass(Class clazz) {
        Assert.notNull((Object)clazz, (String)"a not-null class is required");
        DependencyVisitor visitor = new DependencyVisitor();
        LinkedHashSet<Class> allClasses = new LinkedHashSet<Class>(4);
        allClasses.add(clazz);
        CollectionUtils.mergeArrayIntoCollection(clazz.getDeclaredClasses(), allClasses);
        Iterator iterator = allClasses.iterator();
        while (iterator.hasNext()) {
            Class innerClazz = (Class)iterator.next();
            CollectionUtils.mergeArrayIntoCollection(innerClazz.getDeclaredClasses(), allClasses);
        }
        boolean trace = this.logger.isTraceEnabled();
        if (trace) {
            this.logger.trace((Object)("Discovered classes to analyze " + allClasses));
        }
        Iterator iterator2 = allClasses.iterator();
        while (iterator2.hasNext()) {
            ClassReader reader;
            Class classToVisit = (Class)iterator2.next();
            try {
                if (trace) {
                    this.logger.trace((Object)("Visiting class " + classToVisit));
                }
                reader = new ClassReader(clazz.getResourceAsStream(ClassUtils.getClassFileName((Class)classToVisit)));
            }
            catch (Exception ex) {
                throw (RuntimeException)new IllegalArgumentException("cannot read class " + clazz).initCause(ex);
            }
            reader.accept((ClassVisitor)visitor, false);
        }
        return visitor.getPackages();
    }

    protected void postProcessBundleContext(BundleContext context) throws Exception {
        Resource jar;
        this.logger.debug((Object)"Post processing: creating test bundle");
        Manifest mf = this.getManifest();
        if (this.jarEntries == null) {
            this.jarCreator.setRootPath(this.getRootPath());
            this.jarCreator.setContentPattern(this.getBundleContentPattern());
            jar = this.jarCreator.createJar(mf);
        } else {
            jar = this.jarCreator.createJar(mf, this.jarEntries);
        }
        try {
            this.installAndStartBundle(context, jar);
        }
        catch (Exception e) {
            IllegalStateException ise = new IllegalStateException("Unable to dynamically start generated unit test bundle");
            ise.initCause(e);
            throw ise;
        }
        super.postProcessBundleContext(context);
    }

    private void installAndStartBundle(BundleContext context, Resource resource) throws Exception {
        Bundle bundle = context.installBundle("[onTheFly-test-bundle]" + ClassUtils.getShortName(((Object)((Object)this)).getClass()) + "[" + ((Object)((Object)this)).hashCode() + "]", resource.getInputStream());
        String bundleString = OsgiStringUtils.nullSafeNameAndSymName((Bundle)bundle);
        boolean debug = this.logger.isDebugEnabled();
        if (debug) {
            this.logger.debug((Object)("Test bundle [" + bundleString + "] succesfully installed"));
        }
        bundle.start();
        if (debug) {
            this.logger.debug((Object)("Test bundle [" + bundleString + "] succesfully started"));
        }
    }
}

