/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.test.internal.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestFailure;
import junit.framework.TestResult;
import org.springframework.osgi.test.internal.holder.OsgiTestInfoHolder;

public abstract class TestUtils {
    public static void sendTestResult(TestResult result, ObjectOutputStream stream) {
        ArrayList<Throwable> errorList = new ArrayList<Throwable>();
        Enumeration errors = result.errors();
        while (errors.hasMoreElements()) {
            TestFailure failure = (TestFailure)errors.nextElement();
            errorList.add(failure.thrownException());
        }
        ArrayList<Throwable> failureList = new ArrayList<Throwable>();
        Enumeration failures = result.failures();
        while (failures.hasMoreElements()) {
            TestFailure failure = (TestFailure)failures.nextElement();
            failureList.add(failure.thrownException());
        }
        try {
            stream.writeObject(errorList);
            stream.writeObject(failureList);
            stream.flush();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void receiveTestResult(TestResult testResult, Test test, ObjectInputStream stream) {
        List failures;
        List errors;
        try {
            errors = (List)stream.readObject();
            failures = (List)stream.readObject();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException(ex);
        }
        Iterator iter = errors.iterator();
        while (iter.hasNext()) {
            testResult.addError(test, (Throwable)iter.next());
        }
        iter = failures.iterator();
        while (iter.hasNext()) {
            testResult.addFailure(test, (AssertionFailedError)iter.next());
        }
    }

    public static TestResult cloneTestResults(OsgiTestInfoHolder source, TestResult destination, Test test) {
        Iterator iter = source.getTestErrors().iterator();
        while (iter.hasNext()) {
            destination.addError(test, (Throwable)iter.next());
        }
        iter = source.getTestFailures().iterator();
        while (iter.hasNext()) {
            Throwable originalFailure = (Throwable)iter.next();
            AssertionFailedError clonedFailure = new AssertionFailedError(originalFailure.getMessage());
            clonedFailure.setStackTrace(originalFailure.getStackTrace());
            destination.addFailure(test, clonedFailure);
        }
        return destination;
    }

    public static void unpackProblems(TestResult result, OsgiTestInfoHolder holder) {
        Enumeration errors = result.errors();
        while (errors.hasMoreElements()) {
            TestFailure failure = (TestFailure)errors.nextElement();
            holder.addTestError(failure.thrownException());
        }
        Enumeration failures = result.failures();
        while (failures.hasMoreElements()) {
            TestFailure failure = (TestFailure)failures.nextElement();
            holder.addTestFailure(failure.thrownException());
        }
    }
}

