/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.test.platform;

import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.felix.framework.Felix;
import org.apache.felix.main.Main;
import org.osgi.framework.BundleContext;
import org.springframework.osgi.test.internal.util.IOUtils;
import org.springframework.osgi.test.platform.AbstractOsgiPlatform;
import org.springframework.util.ClassUtils;

public class FelixPlatform
extends AbstractOsgiPlatform {
    private static final Log log = LogFactory.getLog((Class)FelixPlatform.class);
    private static final String FELIX_CONF_FILE = "felix.config.properties";
    private static final String FELIX_CONFIG_PROPERTY = "felix.config.properties";
    private static final String FELIX_PROFILE_DIR_PROPERTY = "felix.cache.profiledir";
    private BundleContext context;
    private Felix platform;
    private File felixStorageDir;

    public FelixPlatform() {
        this.toString = "Felix OSGi Platform";
    }

    protected Properties getPlatformProperties() {
        Properties props = new Properties();
        props.putAll((Map<?, ?>)this.getFelixConfiguration());
        props.putAll((Map<?, ?>)this.getLocalConfiguration());
        return props;
    }

    public BundleContext getBundleContext() {
        return this.context;
    }

    private Properties getLocalConfiguration() {
        Properties props = new Properties();
        this.felixStorageDir = this.createTempDir("felix");
        props.setProperty(FELIX_PROFILE_DIR_PROPERTY, this.felixStorageDir.getAbsolutePath());
        if (log.isTraceEnabled()) {
            log.trace((Object)("felix storage dir is " + this.felixStorageDir.getAbsolutePath()));
        }
        return props;
    }

    private Properties getFelixConfiguration() {
        String location;
        URL url = FelixPlatform.class.getResource(location = "/".concat(ClassUtils.classPackageAsResourcePath((Class)FelixPlatform.class)).concat("/").concat("felix.config.properties"));
        if (url == null) {
            throw new RuntimeException("cannot find felix configuration properties file:" + location);
        }
        System.getProperties().setProperty("felix.config.properties", url.toExternalForm());
        return Main.loadConfigProperties();
    }

    public void start() throws Exception {
        this.platform = new Felix((Map)this.getConfigurationProperties(), null);
        this.platform.start();
        Felix systemBundle = this.platform;
        final Method getContext = systemBundle.getClass().getDeclaredMethod("getBundleContext", null);
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                getContext.setAccessible(true);
                return null;
            }
        });
        this.context = (BundleContext)getContext.invoke((Object)systemBundle, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws Exception {
        try {
            this.platform.stop();
        }
        finally {
            IOUtils.delete(this.felixStorageDir);
        }
    }
}

