/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.test.platform;

import java.io.File;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.knopflerfish.framework.Framework;
import org.osgi.framework.BundleContext;
import org.springframework.core.JdkVersion;
import org.springframework.core.io.ClassPathResource;
import org.springframework.osgi.test.internal.util.IOUtils;
import org.springframework.osgi.test.platform.AbstractOsgiPlatform;

public class KnopflerfishPlatform
extends AbstractOsgiPlatform {
    private BundleContext context;
    private Framework framework;
    private File kfStorageDir;
    private static final String ROOT = "/org/springframework/osgi/test/platform/";
    private static final String PKGS_1_4 = "/org/springframework/osgi/test/platform/kf.packages1.4.txt";
    private static final String PKGS_1_5 = "/org/springframework/osgi/test/platform/kf.packages1.5.txt";

    public KnopflerfishPlatform() {
        this.toString = "Knopflerfish OSGi Platform";
    }

    protected Properties getPlatformProperties() {
        this.kfStorageDir = this.createTempDir("kf");
        Properties props = new Properties();
        props.setProperty("org.osgi.framework.dir", this.kfStorageDir.getAbsolutePath());
        props.setProperty("org.knopflerfish.framework.bundlestorage", "file");
        props.setProperty("org.knopflerfish.framework.bundlestorage.file.reference", "true");
        props.setProperty("org.knopflerfish.framework.bundlestorage.file.unpack", "false");
        props.setProperty("org.knopflerfish.startlevel.use", "true");
        props.setProperty("org.knopflerfish.osgi.setcontextclassloader", "true");
        props.setProperty("org.knopflerfish.framework.exitonshutdown", "false");
        props.setProperty("org.knopflerfish.framework.patch", "false");
        props.setProperty("org.osgi.framework.system.packages", this.loadSystemPackages());
        return props;
    }

    protected String loadSystemPackages() {
        Properties pckgs = new Properties();
        String pckgFile = PKGS_1_4;
        if (JdkVersion.isAtLeastJava15()) {
            pckgFile = PKGS_1_5;
        }
        try {
            pckgs.load(new ClassPathResource(pckgFile).getInputStream());
        }
        catch (Exception ex) {
            this.log.warn((Object)"cannot load system packages", (Throwable)ex);
        }
        StringBuffer bf = new StringBuffer();
        Iterator<Object> iterator = pckgs.keySet().iterator();
        while (iterator.hasNext()) {
            bf.append(iterator.next());
            if (!iterator.hasNext()) continue;
            bf.append(",");
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("loaded system properties [" + bf + "]"));
        }
        return bf.toString();
    }

    public BundleContext getBundleContext() {
        return this.context;
    }

    public void start() throws Exception {
        System.getProperties().putAll((Map<?, ?>)this.getConfigurationProperties());
        this.framework = new Framework((Object)this);
        this.framework.launch(0L);
        this.context = this.framework.getSystemBundleContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws Exception {
        try {
            this.framework.shutdown();
        }
        finally {
            IOUtils.delete(this.kfStorageDir);
        }
    }
}

