/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.test;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URLDecoder;
import junit.framework.Protectable;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestResult;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.osgi.io.OsgiBundleResourceLoader;
import org.springframework.osgi.test.AbstractOptionalDependencyInjectionTests;
import org.springframework.osgi.test.internal.holder.OsgiTestInfoHolder;
import org.springframework.osgi.test.internal.util.TestUtils;
import org.springframework.osgi.test.platform.OsgiPlatform;
import org.springframework.osgi.util.OsgiBundleUtils;
import org.springframework.osgi.util.OsgiPlatformDetector;
import org.springframework.osgi.util.OsgiStringUtils;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

public abstract class AbstractOsgiTests
extends AbstractOptionalDependencyInjectionTests {
    private static final String UTF_8_CHARSET = "UTF-8";
    private static Thread shutdownHook;
    private static OsgiPlatform osgiPlatform;
    private static BundleContext platformContext;
    private static Object service;
    private static Method serviceTrigger;
    private TestResult originalResult;
    protected ResourceLoader resourceLoader;
    private TestCase osgiJUnitTest = this;
    private static final String ACTIVATOR_REFERENCE = "org.springframework.osgi.test.JUnitTestActivator";

    public AbstractOsgiTests() {
    }

    public AbstractOsgiTests(String name) {
        super(name);
    }

    protected abstract Resource[] getTestFrameworkBundles();

    protected abstract Resource[] getTestBundles();

    protected abstract OsgiPlatform createPlatform() throws Exception;

    protected void preProcessBundleContext(BundleContext platformBundleContext) throws Exception {
    }

    protected void postProcessBundleContext(BundleContext platformBundleContext) throws Exception {
    }

    public final void run(TestResult result) {
        this.originalResult = result;
        result.startTest((Test)this.osgiJUnitTest);
        result.runProtected((Test)this.osgiJUnitTest, new Protectable(){

            public void protect() throws Throwable {
                AbstractOsgiTests.this.runBare();
            }
        });
        result.endTest((Test)this.osgiJUnitTest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runBare() throws Throwable {
        if (this.isDisabledInThisEnvironment(this.getName())) {
            this.recordDisabled();
            this.logger.warn((Object)("**** " + ((Object)((Object)this)).getClass().getName() + "." + this.getName() + " disabled in this environment: " + "Total disabled tests=" + AbstractOsgiTests.getDisabledTestCount()));
            return;
        }
        this.prepareTestExecution();
        this.invokeOSGiTestExecution();
        this.readTestResult();
    }

    private void startup() throws Exception {
        if (osgiPlatform == null) {
            int i;
            boolean debug = this.logger.isDebugEnabled();
            this.registerShutdownHook();
            osgiPlatform = this.createPlatform();
            if (debug) {
                this.logger.debug((Object)("About to start " + osgiPlatform));
            }
            osgiPlatform.start();
            platformContext = osgiPlatform.getBundleContext();
            this.logPlatformInfo(platformContext);
            this.preProcessBundleContext(platformContext);
            Resource[] bundleResources = this.locateBundles();
            Bundle[] bundles = new Bundle[bundleResources.length];
            for (i = 0; i < bundles.length; ++i) {
                bundles[i] = this.installBundle(bundleResources[i]);
            }
            for (i = 0; i < bundles.length; ++i) {
                this.startBundle(bundles[i]);
            }
            this.postProcessBundleContext(platformContext);
            this.initializeServiceRunnerInvocationMethods();
        }
    }

    private Resource[] locateBundles() {
        Resource[] testFrameworkBundles = this.getTestFrameworkBundles();
        Resource[] testBundles = this.getTestBundles();
        if (testFrameworkBundles == null) {
            testFrameworkBundles = new Resource[]{};
        }
        if (testBundles == null) {
            testBundles = new Resource[]{};
        }
        Resource[] allBundles = new Resource[testFrameworkBundles.length + testBundles.length];
        System.arraycopy(testFrameworkBundles, 0, allBundles, 0, testFrameworkBundles.length);
        System.arraycopy(testBundles, 0, allBundles, testFrameworkBundles.length, testBundles.length);
        return allBundles;
    }

    private void logPlatformInfo(BundleContext context) {
        StringBuffer platformInfo = new StringBuffer();
        platformInfo.append(osgiPlatform);
        platformInfo.append(" [");
        platformInfo.append(OsgiPlatformDetector.getVersion((BundleContext)context));
        platformInfo.append("]");
        this.logger.info((Object)(platformInfo + " started"));
    }

    private Bundle installBundle(Resource location) throws Exception {
        String bundleLocation;
        Assert.notNull((Object)platformContext);
        Assert.notNull((Object)location);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Installing bundle from location " + location.getDescription()));
        }
        try {
            bundleLocation = URLDecoder.decode(location.getURL().toExternalForm(), UTF_8_CHARSET);
        }
        catch (Exception ex) {
            bundleLocation = location.getDescription();
        }
        return platformContext.installBundle(bundleLocation, location.getInputStream());
    }

    private void startBundle(Bundle bundle) throws BundleException {
        boolean debug = this.logger.isDebugEnabled();
        String info = "[" + OsgiStringUtils.nullSafeNameAndSymName((Bundle)bundle) + "|" + bundle.getLocation() + "]";
        if (!OsgiBundleUtils.isFragment((Bundle)bundle)) {
            if (debug) {
                this.logger.debug((Object)("Starting " + info));
            }
            try {
                bundle.start();
            }
            catch (BundleException ex) {
                this.logger.error((Object)("cannot start bundle " + info), (Throwable)ex);
                throw ex;
            }
        } else if (debug) {
            this.logger.debug((Object)(info + " is a fragment; start not invoked"));
        }
    }

    private void prepareTestExecution() throws Exception {
        if (this.getName() == null) {
            throw new IllegalArgumentException("no test specified");
        }
        OsgiTestInfoHolder.INSTANCE.clearResults();
        OsgiTestInfoHolder.INSTANCE.setTestClassName(this.osgiJUnitTest.getClass().getName());
        try {
            this.startup();
        }
        catch (Exception e) {
            this.logger.debug((Object)"Caught exception starting up", (Throwable)e);
            throw e;
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Writing test name [" + this.getName() + "] to OSGi"));
        }
        OsgiTestInfoHolder.INSTANCE.setTestMethodName(this.getName());
    }

    private void invokeOSGiTestExecution() throws Exception {
        Assert.notNull((Object)serviceTrigger, (String)("no executeTest() method found on: " + service.getClass()));
        try {
            serviceTrigger.invoke(service, null);
        }
        catch (InvocationTargetException ex) {
            Throwable th = ex.getCause();
            if (th instanceof Exception) {
                throw (Exception)th;
            }
            throw (Error)th;
        }
    }

    private void initializeServiceRunnerInvocationMethods() throws Exception {
        BundleContext ctx = this.getRuntimeBundleContext();
        ServiceReference reference = ctx.getServiceReference(ACTIVATOR_REFERENCE);
        Assert.notNull((Object)reference, (String)"no OSGi service reference found at org.springframework.osgi.test.JUnitTestActivator");
        service = ctx.getService(reference);
        Assert.notNull((Object)service, (String)("no service found for reference: " + reference));
        serviceTrigger = service.getClass().getDeclaredMethod("executeTest", null);
        ReflectionUtils.makeAccessible((Method)serviceTrigger);
        Assert.notNull((Object)serviceTrigger, (String)("no executeTest() method found on: " + service.getClass()));
    }

    private BundleContext getRuntimeBundleContext() {
        Long id = OsgiTestInfoHolder.INSTANCE.getTestBundleId();
        BundleContext ctx = null;
        if (id != null) {
            try {
                ctx = OsgiBundleUtils.getBundleContext((Bundle)platformContext.getBundle(id.longValue()));
            }
            catch (RuntimeException ex) {
                this.logger.trace((Object)("cannot determine bundle context for bundle " + id), (Throwable)ex);
            }
        }
        return ctx == null ? platformContext : ctx;
    }

    private void readTestResult() {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Reading OSGi results for test [" + this.getName() + "]"));
        }
        TestUtils.cloneTestResults(OsgiTestInfoHolder.INSTANCE, this.originalResult, (Test)this.osgiJUnitTest);
        if (this.logger.isTraceEnabled()) {
            this.logger.debug((Object)("Test[" + this.getName() + "]'s result read"));
        }
    }

    private void registerShutdownHook() {
        if (shutdownHook == null) {
            shutdownHook = new Thread(){

                public void run() {
                    AbstractOsgiTests.this.shutdownTest();
                }
            };
            Runtime.getRuntime().addShutdownHook(shutdownHook);
        }
    }

    private void shutdownTest() {
        this.logger.info((Object)"Shutting down OSGi platform");
        if (osgiPlatform != null) {
            try {
                osgiPlatform.stop();
            }
            catch (Exception ex) {
                this.logger.warn((Object)("Shutdown procedure threw exception " + ex));
            }
            osgiPlatform = null;
        }
    }

    private void injectBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.resourceLoader = new OsgiBundleResourceLoader(bundleContext.getBundle());
    }

    private void injectOsgiJUnitTest(TestCase test) {
        this.osgiJUnitTest = test;
    }

    private void osgiSetUp() throws Exception {
        this.setUp();
    }

    private void osgiTearDown() throws Exception {
        this.tearDown();
    }

    private void osgiRunTest() throws Throwable {
        super.runTest();
    }
}

