/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.web.deployer.support;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Dictionary;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.Bundle;
import org.springframework.osgi.web.deployer.ContextPathStrategy;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class DefaultContextPathStrategy
implements ContextPathStrategy {
    private static final Log log = LogFactory.getLog(DefaultContextPathStrategy.class);
    private static String encodingScheme = "UTF-8";
    private static String CONTEXT_PATH_HEADER = "Web-ContextPath";
    private static final String SLASH = "/";
    private static final String PREFIX_DELIMITER = ":";
    private static final Pattern ENCODED_SLASH_PTRN = Pattern.compile("%2F");

    public String getContextPath(Bundle bundle) {
        Assert.notNull((Object)bundle);
        String path = this.determineContextPath(bundle);
        if (log.isTraceEnabled()) {
            log.trace((Object)("Detected context path [" + path + "]"));
        }
        String encodedPath = this.encodePath(path);
        if (log.isTraceEnabled()) {
            log.trace((Object)("Encoding context path [" + path + "] to [" + encodedPath + "]"));
        }
        return encodedPath.startsWith(SLASH) ? encodedPath : SLASH.concat(encodedPath);
    }

    protected String determineContextPath(Bundle bundle) {
        boolean trace = log.isTraceEnabled();
        String path = this.getBundleHeader(bundle);
        if (path == null) {
            String location;
            if (trace) {
                log.trace((Object)("No " + CONTEXT_PATH_HEADER + " found; falling back to bundle location..."));
            }
            if (StringUtils.hasText((String)(location = bundle.getLocation()))) {
                path = this.getBundleLocation(location);
            } else {
                Dictionary headers;
                if (trace) {
                    log.trace((Object)"No bundle location found; falling back to bundle name...");
                }
                String string = path = (headers = bundle.getHeaders()) != null ? (String)headers.get("Bundle-Name") : null;
                if (!StringUtils.hasText((String)path)) {
                    if (trace) {
                        log.trace((Object)"No bundle name found; falling back to bundle symbolic name...");
                    }
                    if (!StringUtils.hasText((String)(path = bundle.getSymbolicName()))) {
                        path = ClassUtils.getShortName(bundle.getClass()) + "-" + ObjectUtils.getIdentityHexString((Object)bundle);
                        if (trace) {
                            log.trace((Object)("No bundle symbolic found; returning bundle identity [" + path + "] as context path"));
                        }
                    } else if (trace) {
                        log.trace((Object)("Returning bundle symbolic name [" + path + "] as context path"));
                    }
                } else if (trace) {
                    log.trace((Object)("Returning bundle name [" + path + "] as context path"));
                }
            }
        } else if (trace) {
            log.trace((Object)("Using the bundle " + CONTEXT_PATH_HEADER + " header as context path [" + path + "]"));
        }
        return path;
    }

    private String getBundleHeader(Bundle bundle) {
        Dictionary headers = bundle.getHeaders();
        if (headers == null) {
            return null;
        }
        String header = (String)headers.get(CONTEXT_PATH_HEADER);
        if (header != null) {
            return (header = header.trim()).startsWith(SLASH) ? header.substring(1) : header;
        }
        return null;
    }

    private String getBundleLocation(String location) {
        int index = location.lastIndexOf(PREFIX_DELIMITER);
        String path = index > 0 ? location.substring(index + 1) : location;
        if ((path = StringUtils.cleanPath((String)path)).endsWith(SLASH)) {
            int separatorIndex = (path = path.substring(0, path.length() - 1)).lastIndexOf(SLASH);
            path = separatorIndex > -1 ? path.substring(separatorIndex + 1) : path;
        }
        path = StringUtils.getFilename((String)path);
        path = StringUtils.stripFilenameExtension((String)path);
        if (log.isTraceEnabled()) {
            log.trace((Object)("Bundle location [" + location + "] resulted in context path [" + path + "]"));
        }
        return path;
    }

    private String encodePath(String path) {
        try {
            String encode = URLEncoder.encode(path, encodingScheme);
            String result = ENCODED_SLASH_PTRN.matcher(encode).replaceAll(SLASH);
            return result;
        }
        catch (UnsupportedEncodingException ex) {
            throw (RuntimeException)new IllegalStateException((encodingScheme == null ? "default " : encodingScheme) + " encoding scheme detected but unsable").initCause(ex);
        }
    }

    static {
        try {
            URLEncoder.encode(" \"", encodingScheme);
        }
        catch (UnsupportedEncodingException e) {
            encodingScheme = null;
        }
    }
}

