/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.pulsar.reactive.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.pulsar.client.api.SubscriptionType;
import org.apache.pulsar.common.schema.SchemaType;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.BeanExpressionContext;
import org.springframework.beans.factory.config.BeanExpressionResolver;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.expression.BeanFactoryResolver;
import org.springframework.expression.BeanResolver;
import org.springframework.lang.Nullable;
import org.springframework.pulsar.listener.adapter.AbstractPulsarMessageToSpringMessageAdapter;
import org.springframework.pulsar.reactive.config.ReactivePulsarListenerEndpoint;
import org.springframework.pulsar.reactive.listener.ReactivePulsarMessageHandler;
import org.springframework.pulsar.reactive.listener.ReactivePulsarMessageListenerContainer;
import org.springframework.pulsar.support.MessageConverter;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public abstract class AbstractReactivePulsarListenerEndpoint<T>
implements ReactivePulsarListenerEndpoint<T>,
BeanFactoryAware,
InitializingBean {
    private String subscriptionName;
    private SubscriptionType subscriptionType;
    private SchemaType schemaType;
    private String id;
    private Collection<String> topics = new ArrayList<String>();
    private String topicPattern;
    private BeanFactory beanFactory;
    private BeanExpressionResolver resolver;
    private BeanExpressionContext expressionContext;
    private BeanResolver beanResolver;
    private Boolean autoStartup;
    private Boolean fluxListener;
    private Integer concurrency;
    private Boolean useKeyOrderedProcessing;

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
        if (beanFactory instanceof ConfigurableListableBeanFactory) {
            this.resolver = ((ConfigurableListableBeanFactory)beanFactory).getBeanExpressionResolver();
            this.expressionContext = new BeanExpressionContext((ConfigurableBeanFactory)((ConfigurableListableBeanFactory)beanFactory), null);
        }
        this.beanResolver = new BeanFactoryResolver(beanFactory);
    }

    @Nullable
    protected BeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    public void afterPropertiesSet() {
        boolean topicsEmpty = this.getTopics().isEmpty();
        if (!topicsEmpty && !StringUtils.hasText((String)this.getTopicPattern())) {
            throw new IllegalStateException("Topics or topicPattern must be provided but not both for " + String.valueOf(this));
        }
    }

    @Nullable
    protected BeanExpressionResolver getResolver() {
        return this.resolver;
    }

    @Nullable
    protected BeanExpressionContext getBeanExpressionContext() {
        return this.expressionContext;
    }

    @Nullable
    protected BeanResolver getBeanResolver() {
        return this.beanResolver;
    }

    public void setSubscriptionName(String subscriptionName) {
        this.subscriptionName = subscriptionName;
    }

    @Nullable
    public String getSubscriptionName() {
        return this.subscriptionName;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public void setTopics(String ... topics) {
        Assert.notNull((Object)topics, (String)"'topics' must not be null");
        this.topics = Arrays.asList(topics);
    }

    public List<String> getTopics() {
        return new ArrayList<String>(this.topics);
    }

    public void setTopicPattern(String topicPattern) {
        Assert.notNull((Object)topicPattern, (String)"'topicPattern' must not be null");
        this.topicPattern = topicPattern;
    }

    public String getTopicPattern() {
        return this.topicPattern;
    }

    @Nullable
    public Boolean getAutoStartup() {
        return this.autoStartup;
    }

    public void setAutoStartup(Boolean autoStartup) {
        this.autoStartup = autoStartup;
    }

    public void setupListenerContainer(ReactivePulsarMessageListenerContainer<T> listenerContainer, @Nullable MessageConverter messageConverter) {
        this.setupMessageListener(listenerContainer, messageConverter);
    }

    private void setupMessageListener(ReactivePulsarMessageListenerContainer<T> container, @Nullable MessageConverter messageConverter) {
        AbstractPulsarMessageToSpringMessageAdapter<T> adapter = this.createMessageHandler(container, messageConverter);
        Assert.state((adapter != null ? 1 : 0) != 0, () -> "Endpoint [" + String.valueOf(this) + "] must provide a non null message handler");
        container.setupMessageHandler((ReactivePulsarMessageHandler)adapter);
    }

    protected abstract AbstractPulsarMessageToSpringMessageAdapter<T> createMessageHandler(ReactivePulsarMessageListenerContainer<T> var1, @Nullable MessageConverter var2);

    @Nullable
    public Boolean getFluxListener() {
        return this.fluxListener;
    }

    public void setFluxListener(boolean fluxListener) {
        this.fluxListener = fluxListener;
    }

    @Override
    public boolean isFluxListener() {
        return this.fluxListener != null && this.fluxListener != false;
    }

    public SubscriptionType getSubscriptionType() {
        return this.subscriptionType;
    }

    public void setSubscriptionType(SubscriptionType subscriptionType) {
        this.subscriptionType = subscriptionType;
    }

    public SchemaType getSchemaType() {
        return this.schemaType;
    }

    public void setSchemaType(SchemaType schemaType) {
        this.schemaType = schemaType;
    }

    @Nullable
    public Integer getConcurrency() {
        return this.concurrency;
    }

    public void setConcurrency(Integer concurrency) {
        this.concurrency = concurrency;
    }

    @Override
    public Boolean getUseKeyOrderedProcessing() {
        return this.useKeyOrderedProcessing;
    }

    public void setUseKeyOrderedProcessing(Boolean useKeyOrderedProcessing) {
        this.useKeyOrderedProcessing = useKeyOrderedProcessing;
    }
}

