/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.pulsar.test.support;

import org.junit.jupiter.api.BeforeAll;
import org.testcontainers.containers.PulsarContainer;
import org.testcontainers.junit.jupiter.Testcontainers;
import org.testcontainers.utility.DockerImageName;

@Testcontainers(disabledWithoutDocker=true)
public interface PulsarTestContainerSupport {
    public static final PulsarContainer PULSAR_CONTAINER = new PulsarContainer(PulsarTestContainerSupport.getPulsarImage());

    public static DockerImageName getPulsarImage() {
        return DockerImageName.parse((String)"apachepulsar/pulsar:3.3.5");
    }

    @BeforeAll
    public static void startContainer() {
        PULSAR_CONTAINER.start();
    }

    public static void stopContainer() {
        PULSAR_CONTAINER.stop();
    }

    public static String getPulsarBrokerUrl() {
        return PULSAR_CONTAINER.getPulsarBrokerUrl();
    }

    public static String getHttpServiceUrl() {
        return PULSAR_CONTAINER.getHttpServiceUrl();
    }

    public static boolean isContainerStarted() {
        return PULSAR_CONTAINER.isRunning();
    }
}

