/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.pulsar.transaction;

import org.apache.pulsar.client.api.PulsarClient;
import org.springframework.pulsar.transaction.PulsarResourceHolder;
import org.springframework.transaction.support.ResourceHolder;
import org.springframework.transaction.support.ResourceHolderSynchronization;

class PulsarResourceSynchronization
extends ResourceHolderSynchronization<PulsarResourceHolder, PulsarClient> {
    private final PulsarResourceHolder resourceHolder;

    PulsarResourceSynchronization(PulsarResourceHolder resourceHolder, PulsarClient resourceKey) {
        super((ResourceHolder)resourceHolder, (Object)resourceKey);
        this.resourceHolder = resourceHolder;
    }

    protected boolean shouldReleaseBeforeCompletion() {
        return false;
    }

    protected void processResourceAfterCommit(PulsarResourceHolder resourceHolder) {
        resourceHolder.commit();
    }

    public void afterCompletion(int status) {
        try {
            if (status == 0) {
                this.resourceHolder.commit();
            } else {
                this.resourceHolder.rollback();
            }
        }
        finally {
            super.afterCompletion(status);
        }
    }
}

