/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.restdocs.mockmvc;

import java.util.HashMap;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.restdocs.RestDocumentationContext;
import org.springframework.restdocs.RestDocumentationContextProvider;
import org.springframework.restdocs.config.RestDocumentationConfigurer;
import org.springframework.restdocs.mockmvc.MockMvcSnippetConfigurer;
import org.springframework.restdocs.mockmvc.UriConfigurer;
import org.springframework.test.web.servlet.request.RequestPostProcessor;
import org.springframework.test.web.servlet.setup.ConfigurableMockMvcBuilder;
import org.springframework.test.web.servlet.setup.MockMvcConfigurer;
import org.springframework.web.context.WebApplicationContext;

public class MockMvcRestDocumentationConfigurer
extends RestDocumentationConfigurer<MockMvcSnippetConfigurer, MockMvcRestDocumentationConfigurer>
implements MockMvcConfigurer {
    private final MockMvcSnippetConfigurer snippetConfigurer = new MockMvcSnippetConfigurer(this);
    private final UriConfigurer uriConfigurer = new UriConfigurer(this);
    private final RestDocumentationContextProvider contextManager;

    MockMvcRestDocumentationConfigurer(RestDocumentationContextProvider contextManager) {
        this.contextManager = contextManager;
    }

    public UriConfigurer uris() {
        return this.uriConfigurer;
    }

    public RequestPostProcessor beforeMockMvcCreated(ConfigurableMockMvcBuilder<?> builder, WebApplicationContext context) {
        return new ConfigurerApplyingRequestPostProcessor(this.contextManager);
    }

    public void afterConfigurerAdded(ConfigurableMockMvcBuilder<?> builder) {
    }

    public MockMvcSnippetConfigurer snippets() {
        return this.snippetConfigurer;
    }

    private final class ConfigurerApplyingRequestPostProcessor
    implements RequestPostProcessor {
        private final RestDocumentationContextProvider contextManager;

        private ConfigurerApplyingRequestPostProcessor(RestDocumentationContextProvider contextManager) {
            this.contextManager = contextManager;
        }

        public MockHttpServletRequest postProcessRequest(MockHttpServletRequest request) {
            RestDocumentationContext context = this.contextManager.beforeOperation();
            HashMap<String, Object> configuration = new HashMap<String, Object>();
            configuration.put(MockHttpServletRequest.class.getName(), request);
            configuration.put("org.springframework.restdocs.urlTemplate", request.getAttribute("org.springframework.restdocs.urlTemplate"));
            configuration.put(RestDocumentationContext.class.getName(), context);
            request.setAttribute("org.springframework.restdocs.configuration", configuration);
            MockMvcRestDocumentationConfigurer.this.apply(configuration, context);
            MockMvcRestDocumentationConfigurer.this.uriConfigurer.apply(configuration, context);
            return request;
        }
    }
}

