/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.restdocs.webtestclient;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.springframework.restdocs.RestDocumentationContextProvider;
import org.springframework.restdocs.generate.RestDocumentationGenerator;
import org.springframework.restdocs.operation.RequestConverter;
import org.springframework.restdocs.operation.ResponseConverter;
import org.springframework.restdocs.operation.preprocess.OperationRequestPreprocessor;
import org.springframework.restdocs.operation.preprocess.OperationResponsePreprocessor;
import org.springframework.restdocs.snippet.Snippet;
import org.springframework.restdocs.webtestclient.WebTestClientRequestConverter;
import org.springframework.restdocs.webtestclient.WebTestClientResponseConverter;
import org.springframework.restdocs.webtestclient.WebTestClientRestDocumentationConfigurer;
import org.springframework.test.web.reactive.server.ExchangeResult;

public abstract class WebTestClientRestDocumentation {
    private static final WebTestClientRequestConverter REQUEST_CONVERTER = new WebTestClientRequestConverter();
    private static final WebTestClientResponseConverter RESPONSE_CONVERTER = new WebTestClientResponseConverter();

    private WebTestClientRestDocumentation() {
    }

    public static WebTestClientRestDocumentationConfigurer documentationConfiguration(RestDocumentationContextProvider contextProvider) {
        return new WebTestClientRestDocumentationConfigurer(contextProvider);
    }

    public static <T extends ExchangeResult> Consumer<T> document(String identifier, Snippet ... snippets) {
        return result -> new RestDocumentationGenerator(identifier, (RequestConverter)REQUEST_CONVERTER, (ResponseConverter)RESPONSE_CONVERTER, snippets).handle(result, result, WebTestClientRestDocumentation.retrieveConfiguration(result));
    }

    public static <T extends ExchangeResult> Consumer<T> document(String identifier, OperationRequestPreprocessor requestPreprocessor, Snippet ... snippets) {
        return result -> new RestDocumentationGenerator(identifier, (RequestConverter)REQUEST_CONVERTER, (ResponseConverter)RESPONSE_CONVERTER, requestPreprocessor, snippets).handle(result, result, WebTestClientRestDocumentation.retrieveConfiguration(result));
    }

    public static <T extends ExchangeResult> Consumer<T> document(String identifier, OperationResponsePreprocessor responsePreprocessor, Snippet ... snippets) {
        return result -> new RestDocumentationGenerator(identifier, (RequestConverter)REQUEST_CONVERTER, (ResponseConverter)RESPONSE_CONVERTER, responsePreprocessor, snippets).handle(result, result, WebTestClientRestDocumentation.retrieveConfiguration(result));
    }

    public static <T extends ExchangeResult> Consumer<T> document(String identifier, OperationRequestPreprocessor requestPreprocessor, OperationResponsePreprocessor responsePreprocessor, Snippet ... snippets) {
        return result -> new RestDocumentationGenerator(identifier, (RequestConverter)REQUEST_CONVERTER, (ResponseConverter)RESPONSE_CONVERTER, requestPreprocessor, responsePreprocessor, snippets).handle(result, result, WebTestClientRestDocumentation.retrieveConfiguration(result));
    }

    private static Map<String, Object> retrieveConfiguration(ExchangeResult result) {
        HashMap<String, Object> configuration = new HashMap<String, Object>(WebTestClientRestDocumentationConfigurer.retrieveConfiguration(result.getRequestHeaders()));
        configuration.put("org.springframework.restdocs.urlTemplate", result.getUriTemplate());
        return configuration;
    }
}

