/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth.consumer.token;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.oauth.consumer.OAuthConsumerToken;
import org.springframework.security.oauth.consumer.OAuthSecurityContext;
import org.springframework.security.oauth.consumer.OAuthSecurityContextHolder;
import org.springframework.security.oauth.consumer.token.OAuthConsumerTokenServices;

public class HttpSessionBasedTokenServices
implements OAuthConsumerTokenServices {
    public static final String KEY_PREFIX = "OAUTH_TOKEN";

    @Override
    public OAuthConsumerToken getToken(String resourceId) throws AuthenticationException {
        Long expiration;
        HttpSession session = this.getSession();
        OAuthConsumerToken consumerToken = (OAuthConsumerToken)session.getAttribute("OAUTH_TOKEN#" + resourceId);
        if (consumerToken != null && (expiration = (Long)session.getAttribute("OAUTH_TOKEN#" + resourceId + "#EXPIRATION")) != null && System.currentTimeMillis() > expiration) {
            this.removeToken(resourceId);
            consumerToken = null;
        }
        return consumerToken;
    }

    @Override
    public void storeToken(String resourceId, OAuthConsumerToken token) {
        String expiresInValue;
        HttpSession session = this.getSession();
        session.setAttribute("OAUTH_TOKEN#" + resourceId, (Object)token);
        Long expiration = null;
        String string = expiresInValue = token.getAdditionalParameters() != null ? token.getAdditionalParameters().get("oauth_expires_in") : null;
        if (expiresInValue != null) {
            try {
                expiration = System.currentTimeMillis() + (long)(Integer.parseInt(expiresInValue) * 1000);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if (expiration != null) {
            session.setAttribute("OAUTH_TOKEN#" + resourceId + "#EXPIRATION", (Object)expiration);
        }
    }

    @Override
    public void removeToken(String resourceId) {
        this.getSession().removeAttribute("OAUTH_TOKEN#" + resourceId);
    }

    protected HttpSession getSession() {
        HttpServletRequest request;
        OAuthSecurityContext context = OAuthSecurityContextHolder.getContext();
        if (context == null) {
            throw new IllegalStateException("A security context must be established.");
        }
        try {
            request = (HttpServletRequest)context.getDetails();
        }
        catch (ClassCastException e) {
            throw new IllegalStateException("The security context must have the HTTP servlet request as its details.");
        }
        if (request == null) {
            throw new IllegalStateException("The security context must have the HTTP servlet request as its details.");
        }
        HttpSession session = request.getSession(true);
        if (session == null) {
            throw new IllegalStateException("Unable to create a session in which to store the tokens.");
        }
        return session;
    }
}

