/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth.common.signature;

import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.oauth.common.signature.InvalidSignatureException;
import org.springframework.security.oauth.common.signature.OAuthSignatureMethod;

public class HMAC_SHA1SignatureMethod
implements OAuthSignatureMethod {
    private static final Log LOG = LogFactory.getLog(HMAC_SHA1SignatureMethod.class);
    public static final String SIGNATURE_NAME = "HMAC-SHA1";
    public static final String MAC_NAME = "HmacSHA1";
    private final SecretKey key;

    public HMAC_SHA1SignatureMethod(SecretKey key) {
        this.key = key;
    }

    @Override
    public String getName() {
        return SIGNATURE_NAME;
    }

    @Override
    public String sign(String signatureBaseString) {
        try {
            Mac mac = Mac.getInstance(MAC_NAME);
            mac.init(this.key);
            byte[] text = signatureBaseString.getBytes("UTF-8");
            byte[] signatureBytes = mac.doFinal(text);
            signatureBytes = Base64.encodeBase64((byte[])signatureBytes);
            String signature = new String(signatureBytes, "UTF-8");
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("signature base: " + signatureBaseString));
                LOG.debug((Object)("signature: " + signature));
            }
            return signature;
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
        catch (InvalidKeyException e) {
            throw new IllegalStateException(e);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void verify(String signatureBaseString, String signature) throws InvalidSignatureException {
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("signature base: " + signatureBaseString));
                LOG.debug((Object)("signature: " + signature));
            }
            byte[] signatureBytes = Base64.decodeBase64((byte[])signature.getBytes("UTF-8"));
            Mac mac = Mac.getInstance(MAC_NAME);
            mac.init(this.key);
            byte[] text = signatureBaseString.getBytes("UTF-8");
            byte[] calculatedBytes = mac.doFinal(text);
            if (!this.safeArrayEquals(calculatedBytes, signatureBytes)) {
                throw new InvalidSignatureException("Invalid signature for signature method " + this.getName());
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
        catch (InvalidKeyException e) {
            throw new IllegalStateException(e);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    boolean safeArrayEquals(byte[] a1, byte[] a2) {
        if (a1 == null || a2 == null) {
            return a1 == a2;
        }
        if (a1.length != a2.length) {
            return false;
        }
        int result = 0;
        int i = 0;
        while (i < a1.length) {
            result = (byte)(result | a1[i] ^ a2[i]);
            ++i;
        }
        return result == 0;
    }

    public SecretKey getSecretKey() {
        return this.key;
    }
}

