/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.springframework.security.oauth2.client.OAuth2ClientContext;
import org.springframework.security.oauth2.client.token.AccessTokenRequest;
import org.springframework.security.oauth2.client.token.DefaultAccessTokenRequest;
import org.springframework.security.oauth2.common.OAuth2AccessToken;

public class DefaultOAuth2ClientContext
implements OAuth2ClientContext,
Serializable {
    private OAuth2AccessToken accessToken;
    private AccessTokenRequest accessTokenRequest;
    private Map<String, Object> state = new HashMap<String, Object>();

    public DefaultOAuth2ClientContext() {
        this(new DefaultAccessTokenRequest());
    }

    public DefaultOAuth2ClientContext(AccessTokenRequest accessTokenRequest) {
        this.accessTokenRequest = accessTokenRequest;
    }

    public DefaultOAuth2ClientContext(OAuth2AccessToken accessToken) {
        this.accessToken = accessToken;
        this.accessTokenRequest = new DefaultAccessTokenRequest();
    }

    public OAuth2AccessToken getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(OAuth2AccessToken accessToken) {
        this.accessToken = accessToken;
        this.accessTokenRequest.setExistingToken(accessToken);
    }

    public AccessTokenRequest getAccessTokenRequest() {
        return this.accessTokenRequest;
    }

    public void setPreservedState(String stateKey, Object preservedState) {
        this.state.put(stateKey, preservedState);
    }

    public Object removePreservedState(String stateKey) {
        return this.state.remove(stateKey);
    }
}

