/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.provider;

import java.util.ArrayList;
import java.util.List;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.provider.AuthorizationRequest;
import org.springframework.security.oauth2.provider.TokenGranter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeTokenGranter
implements TokenGranter {
    private final List<TokenGranter> tokenGranters;

    public CompositeTokenGranter(List<TokenGranter> tokenGranters) {
        this.tokenGranters = new ArrayList<TokenGranter>(tokenGranters);
    }

    @Override
    public OAuth2AccessToken grant(String grantType, AuthorizationRequest authorizationRequest) {
        for (TokenGranter granter : this.tokenGranters) {
            OAuth2AccessToken grant = granter.grant(grantType, authorizationRequest);
            if (grant == null) continue;
            return grant;
        }
        return null;
    }
}

