/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.security.web.authentication.AbstractAuthenticationProcessingFilter;
import org.springframework.security.web.authentication.RememberMeServices;
import org.springframework.security.web.authentication.www.BasicProcessingFilter;
import org.springframework.util.Assert;

public class RememberMeServicesInjectionBeanPostProcessor
implements BeanPostProcessor,
BeanFactoryAware {
    private Log logger = LogFactory.getLog(this.getClass());
    private ListableBeanFactory beanFactory;

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof AbstractAuthenticationProcessingFilter) {
            AbstractAuthenticationProcessingFilter pf = (AbstractAuthenticationProcessingFilter)bean;
            if (pf.getRememberMeServices() == null) {
                this.logger.info((Object)("Setting RememberMeServices on bean " + beanName));
                pf.setRememberMeServices(this.getRememberMeServices());
            }
        } else if ("_basicAuthenticationFilter".equals(beanName)) {
            BasicProcessingFilter bf = (BasicProcessingFilter)bean;
            this.logger.info((Object)("Setting RememberMeServices on bean " + beanName));
            bf.setRememberMeServices(this.getRememberMeServices());
        }
        return bean;
    }

    private RememberMeServices getRememberMeServices() {
        Map beans = this.beanFactory.getBeansOfType(RememberMeServices.class);
        Assert.isTrue((beans.size() > 0 ? 1 : 0) != 0, (String)"No RememberMeServices configured");
        Assert.isTrue((beans.size() == 1 ? 1 : 0) != 0, (String)"Use of '<remember-me />' requires a single instance of RememberMeServices in the application context, but more than one was found.");
        return (RememberMeServices)beans.values().toArray()[0];
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = (ListableBeanFactory)beanFactory;
    }
}

