/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config;

import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.security.authentication.concurrent.ConcurrentSessionController;
import org.springframework.security.authentication.concurrent.ConcurrentSessionControllerImpl;
import org.springframework.security.authentication.concurrent.SessionRegistry;
import org.springframework.security.config.SecurityConfigurationException;
import org.springframework.security.web.authentication.AbstractAuthenticationProcessingFilter;
import org.springframework.security.web.session.SessionFixationProtectionFilter;

class SessionRegistryInjectionBeanPostProcessor
implements BeanPostProcessor,
BeanFactoryAware {
    private final Log logger = LogFactory.getLog(this.getClass());
    private ListableBeanFactory beanFactory;
    private SessionRegistry sessionRegistry;
    private final String controllerBeanName;

    SessionRegistryInjectionBeanPostProcessor(String controllerBeanName) {
        this.controllerBeanName = controllerBeanName;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        if ("_formLoginFilter".equals(beanName) || "_openIDFilter".equals(beanName)) {
            ((AbstractAuthenticationProcessingFilter)bean).setSessionRegistry(this.getSessionRegistry());
        } else if ("_sessionFixationProtectionFilter".equals(beanName)) {
            ((SessionFixationProtectionFilter)bean).setSessionRegistry(this.getSessionRegistry());
        }
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    private SessionRegistry getSessionRegistry() {
        if (this.sessionRegistry != null) {
            return this.sessionRegistry;
        }
        this.logger.info((Object)"Attempting to read SessionRegistry from registered ConcurrentSessionController bean");
        ConcurrentSessionController controller = (ConcurrentSessionController)this.beanFactory.getBean(this.controllerBeanName);
        if (controller instanceof ConcurrentSessionControllerImpl) {
            this.sessionRegistry = ((ConcurrentSessionControllerImpl)controller).getSessionRegistry();
            return this.sessionRegistry;
        }
        this.logger.info((Object)"ConcurrentSessionController is not a standard implementation. SessionRegistry could not be read from it. Looking for it in the context.");
        ArrayList sessionRegs = new ArrayList(this.beanFactory.getBeansOfType(SessionRegistry.class).values());
        if (sessionRegs.size() == 0) {
            throw new SecurityConfigurationException("concurrent-session-controller-ref was set but no SessionRegistry could be obtained from the application context.");
        }
        if (sessionRegs.size() > 1) {
            this.logger.warn((Object)"More than one SessionRegistry instance in application context. Possible configuration errors may result.");
        }
        this.sessionRegistry = (SessionRegistry)sessionRegs.get(0);
        return this.sessionRegistry;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = (ListableBeanFactory)beanFactory;
    }
}

