/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.method;

import java.util.LinkedHashMap;
import java.util.List;
import org.springframework.aop.config.AbstractInterceptorDrivenBeanDefinitionDecorator;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.security.access.SecurityConfig;
import org.springframework.security.access.intercept.aopalliance.MethodSecurityInterceptor;
import org.springframework.security.access.method.MapBasedMethodSecurityMetadataSource;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class InternalInterceptMethodsBeanDefinitionDecorator
extends AbstractInterceptorDrivenBeanDefinitionDecorator {
    static final String ATT_METHOD = "method";
    static final String ATT_ACCESS = "access";
    private static final String ATT_ACCESS_MGR = "access-decision-manager-ref";

    InternalInterceptMethodsBeanDefinitionDecorator() {
    }

    protected BeanDefinition createInterceptorDefinition(Node node) {
        Element interceptMethodsElt = (Element)node;
        BeanDefinitionBuilder interceptor = BeanDefinitionBuilder.rootBeanDefinition(MethodSecurityInterceptor.class);
        interceptor.setAutowireMode(2);
        String accessManagerId = interceptMethodsElt.getAttribute(ATT_ACCESS_MGR);
        if (!StringUtils.hasText((String)accessManagerId)) {
            accessManagerId = "org.springframework.security.defaultMethodAccessManager";
        }
        interceptor.addPropertyValue("accessDecisionManager", (Object)new RuntimeBeanReference(accessManagerId));
        interceptor.addPropertyValue("authenticationManager", (Object)new RuntimeBeanReference("org.springframework.security.authenticationManager"));
        Element parent = (Element)node.getParentNode();
        String parentBeanClass = parent.getAttribute("class");
        List methods = DomUtils.getChildElementsByTagName((Element)interceptMethodsElt, (String)"protect");
        LinkedHashMap<String, List> mappings = new LinkedHashMap<String, List>();
        for (Element protectmethodElt : methods) {
            String[] tokens = StringUtils.commaDelimitedListToStringArray((String)protectmethodElt.getAttribute(ATT_ACCESS));
            String methodName = protectmethodElt.getAttribute(ATT_METHOD);
            if (methodName.lastIndexOf(".") == -1 && parentBeanClass != null && !"".equals(parentBeanClass)) {
                methodName = parentBeanClass + "." + methodName;
            }
            mappings.put(methodName, SecurityConfig.createList((String[])tokens));
        }
        RootBeanDefinition metadataSource = new RootBeanDefinition(MapBasedMethodSecurityMetadataSource.class);
        metadataSource.getConstructorArgumentValues().addGenericArgumentValue(mappings);
        interceptor.addPropertyValue("securityMetadataSource", (Object)metadataSource);
        return interceptor.getBeanDefinition();
    }
}

