/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.configuration;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.security.config.annotation.ObjectPostProcessor;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class AutowireBeanFactoryObjectPostProcessor
implements ObjectPostProcessor<Object>,
DisposableBean {
    private final Log logger = LogFactory.getLog(this.getClass());
    private final AutowireCapableBeanFactory autowireBeanFactory;
    private final List<DisposableBean> disposableBeans = new ArrayList<DisposableBean>();

    public AutowireBeanFactoryObjectPostProcessor(AutowireCapableBeanFactory autowireBeanFactory) {
        Assert.notNull((Object)autowireBeanFactory, (String)"autowireBeanFactory cannot be null");
        this.autowireBeanFactory = autowireBeanFactory;
    }

    @Override
    public <T> T postProcess(T object) {
        Object result = this.autowireBeanFactory.initializeBean(object, null);
        if (result instanceof DisposableBean) {
            this.disposableBeans.add((DisposableBean)result);
        }
        return (T)result;
    }

    public void destroy() throws Exception {
        for (DisposableBean disposable : this.disposableBeans) {
            try {
                disposable.destroy();
            }
            catch (Exception error) {
                this.logger.error((Object)error);
            }
        }
    }
}

