/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web.configurers;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import javax.servlet.Filter;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.access.SecurityConfig;
import org.springframework.security.config.annotation.ObjectPostProcessor;
import org.springframework.security.config.annotation.web.HttpSecurityBuilder;
import org.springframework.security.config.annotation.web.configurers.AbstractRequestMatcherMappingConfigurer;
import org.springframework.security.web.DefaultSecurityFilterChain;
import org.springframework.security.web.PortMapper;
import org.springframework.security.web.access.channel.ChannelDecisionManager;
import org.springframework.security.web.access.channel.ChannelDecisionManagerImpl;
import org.springframework.security.web.access.channel.ChannelEntryPoint;
import org.springframework.security.web.access.channel.ChannelProcessingFilter;
import org.springframework.security.web.access.channel.ChannelProcessor;
import org.springframework.security.web.access.channel.InsecureChannelProcessor;
import org.springframework.security.web.access.channel.RetryWithHttpEntryPoint;
import org.springframework.security.web.access.channel.RetryWithHttpsEntryPoint;
import org.springframework.security.web.access.channel.SecureChannelProcessor;
import org.springframework.security.web.access.intercept.DefaultFilterInvocationSecurityMetadataSource;
import org.springframework.security.web.access.intercept.FilterInvocationSecurityMetadataSource;
import org.springframework.security.web.util.RequestMatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ChannelSecurityConfigurer<H extends HttpSecurityBuilder<H>>
extends AbstractRequestMatcherMappingConfigurer<H, RequiresChannelUrl, DefaultSecurityFilterChain> {
    private ChannelProcessingFilter channelFilter = new ChannelProcessingFilter();
    private LinkedHashMap<RequestMatcher, Collection<ConfigAttribute>> requestMap = new LinkedHashMap();
    private List<ChannelProcessor> channelProcessors;

    @Override
    public void configure(H http) throws Exception {
        ChannelDecisionManagerImpl channelDecisionManager = new ChannelDecisionManagerImpl();
        channelDecisionManager.setChannelProcessors(this.getChannelProcessors(http));
        channelDecisionManager = this.postProcess(channelDecisionManager);
        this.channelFilter.setChannelDecisionManager((ChannelDecisionManager)channelDecisionManager);
        DefaultFilterInvocationSecurityMetadataSource filterInvocationSecurityMetadataSource = new DefaultFilterInvocationSecurityMetadataSource(this.requestMap);
        this.channelFilter.setSecurityMetadataSource((FilterInvocationSecurityMetadataSource)filterInvocationSecurityMetadataSource);
        this.channelFilter = this.postProcess(this.channelFilter);
        http.addFilter((Filter)this.channelFilter);
    }

    public ChannelSecurityConfigurer<H> withObjectPostProcessor(ObjectPostProcessor<?> objectPostProcessor) {
        this.addObjectPostProcessor(objectPostProcessor);
        return this;
    }

    public ChannelSecurityConfigurer<H> channelProcessors(List<ChannelProcessor> channelProcessors) {
        this.channelProcessors = channelProcessors;
        return this;
    }

    private List<ChannelProcessor> getChannelProcessors(H http) {
        if (this.channelProcessors != null) {
            return this.channelProcessors;
        }
        InsecureChannelProcessor insecureChannelProcessor = new InsecureChannelProcessor();
        SecureChannelProcessor secureChannelProcessor = new SecureChannelProcessor();
        PortMapper portMapper = http.getSharedObject(PortMapper.class);
        if (portMapper != null) {
            RetryWithHttpEntryPoint httpEntryPoint = new RetryWithHttpEntryPoint();
            httpEntryPoint.setPortMapper(portMapper);
            insecureChannelProcessor.setEntryPoint((ChannelEntryPoint)httpEntryPoint);
            RetryWithHttpsEntryPoint httpsEntryPoint = new RetryWithHttpsEntryPoint();
            httpsEntryPoint.setPortMapper(portMapper);
            secureChannelProcessor.setEntryPoint((ChannelEntryPoint)httpsEntryPoint);
        }
        insecureChannelProcessor = this.postProcess(insecureChannelProcessor);
        secureChannelProcessor = this.postProcess(secureChannelProcessor);
        return Arrays.asList(insecureChannelProcessor, secureChannelProcessor);
    }

    private ChannelSecurityConfigurer<H> addAttribute(String attribute, List<RequestMatcher> matchers) {
        for (RequestMatcher matcher : matchers) {
            List<ConfigAttribute> attrs = Arrays.asList(new SecurityConfig(attribute));
            this.requestMap.put(matcher, attrs);
        }
        return this;
    }

    @Override
    protected RequiresChannelUrl chainRequestMatchersInternal(List<RequestMatcher> requestMatchers) {
        return new RequiresChannelUrl(requestMatchers);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class RequiresChannelUrl {
        private List<RequestMatcher> requestMatchers;

        private RequiresChannelUrl(List<RequestMatcher> requestMatchers) {
            this.requestMatchers = requestMatchers;
        }

        public ChannelSecurityConfigurer<H> requiresSecure() {
            return this.requires("REQUIRES_SECURE_CHANNEL");
        }

        public ChannelSecurityConfigurer<H> requiresInsecure() {
            return this.requires("REQUIRES_INSECURE_CHANNEL");
        }

        public ChannelSecurityConfigurer<H> requires(String attribute) {
            return ChannelSecurityConfigurer.this.addAttribute(attribute, this.requestMatchers);
        }
    }
}

