/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web.configurers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.security.access.AccessDecisionVoter;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.access.SecurityConfig;
import org.springframework.security.access.vote.AuthenticatedVoter;
import org.springframework.security.access.vote.RoleVoter;
import org.springframework.security.config.annotation.ObjectPostProcessor;
import org.springframework.security.config.annotation.web.HttpSecurityBuilder;
import org.springframework.security.config.annotation.web.configurers.AbstractInterceptUrlConfigurer;
import org.springframework.security.config.annotation.web.configurers.AbstractRequestMatcherMappingConfigurer;
import org.springframework.security.web.access.intercept.DefaultFilterInvocationSecurityMetadataSource;
import org.springframework.security.web.access.intercept.FilterInvocationSecurityMetadataSource;
import org.springframework.security.web.util.RequestMatcher;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UrlAuthorizationConfigurer<H extends HttpSecurityBuilder<H>, C>
extends AbstractInterceptUrlConfigurer<H, C, AuthorizedUrl> {
    public UrlAuthorizationConfigurer<H, C> withObjectPostProcessor(ObjectPostProcessor<?> objectPostProcessor) {
        this.addObjectPostProcessor(objectPostProcessor);
        return this;
    }

    @Override
    final List<AccessDecisionVoter> getDecisionVoters() {
        ArrayList<AccessDecisionVoter> decisionVoters = new ArrayList<AccessDecisionVoter>();
        decisionVoters.add((AccessDecisionVoter)new RoleVoter());
        decisionVoters.add((AccessDecisionVoter)new AuthenticatedVoter());
        return decisionVoters;
    }

    @Override
    FilterInvocationSecurityMetadataSource createMetadataSource() {
        return new DefaultFilterInvocationSecurityMetadataSource(this.createRequestMap());
    }

    @Override
    protected AuthorizedUrl chainRequestMatchersInternal(List<RequestMatcher> requestMatchers) {
        return new AuthorizedUrl(requestMatchers);
    }

    private UrlAuthorizationConfigurer<H, C> addMapping(Iterable<? extends RequestMatcher> requestMatchers, Collection<ConfigAttribute> configAttributes) {
        for (RequestMatcher requestMatcher : requestMatchers) {
            this.addMapping(new AbstractRequestMatcherMappingConfigurer.UrlMapping(requestMatcher, configAttributes));
        }
        return this;
    }

    private static String hasRole(String role) {
        Assert.isTrue((!role.startsWith("ROLE_") ? 1 : 0) != 0, (String)(role + " should not start with ROLE_ since ROLE_ is automatically prepended when using hasRole. Consider using hasAuthority or access instead."));
        return "ROLE_" + role;
    }

    private static String[] hasAnyRole(String ... roles) {
        for (int i = 0; i < roles.length; ++i) {
            roles[i] = "ROLE_" + roles[i];
        }
        return roles;
    }

    private static String[] hasAnyAuthority(String ... authorities) {
        return authorities;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class AuthorizedUrl {
        private final List<RequestMatcher> requestMatchers;

        private AuthorizedUrl(List<RequestMatcher> requestMatchers) {
            Assert.notEmpty(requestMatchers, (String)"requestMatchers must contain at least one value");
            this.requestMatchers = requestMatchers;
        }

        public UrlAuthorizationConfigurer<H, C> hasRole(String role) {
            return this.access(UrlAuthorizationConfigurer.hasRole(role));
        }

        public UrlAuthorizationConfigurer<H, C> hasAnyRole(String ... roles) {
            return this.access(UrlAuthorizationConfigurer.hasAnyRole(roles));
        }

        public UrlAuthorizationConfigurer<H, C> hasAuthority(String authority) {
            return this.access(authority);
        }

        public UrlAuthorizationConfigurer<H, C> hasAnyAuthority(String ... authorities) {
            return this.access(UrlAuthorizationConfigurer.hasAnyAuthority(authorities));
        }

        public UrlAuthorizationConfigurer<H, C> anonymous() {
            return this.hasRole("ROLE_ANONYMOUS");
        }

        public UrlAuthorizationConfigurer<H, C> access(String ... attributes) {
            UrlAuthorizationConfigurer.this.addMapping(this.requestMatchers, SecurityConfig.createList((String[])attributes));
            return UrlAuthorizationConfigurer.this;
        }
    }
}

