/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.http;

import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.security.web.csrf.CsrfAuthenticationStrategy;
import org.springframework.security.web.csrf.CsrfFilter;
import org.springframework.security.web.csrf.CsrfLogoutHandler;
import org.springframework.security.web.csrf.HttpSessionCsrfTokenRepository;
import org.springframework.security.web.servlet.support.csrf.CsrfRequestDataValueProcessor;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class CsrfBeanDefinitionParser
implements BeanDefinitionParser {
    private static final String REQUEST_DATA_VALUE_PROCESSOR = "requestDataValueProcessor";
    private static final String DISPATCHER_SERVLET_CLASS_NAME = "org.springframework.web.servlet.DispatcherServlet";
    private static final String ATT_MATCHER = "request-matcher-ref";
    private static final String ATT_REPOSITORY = "token-repository-ref";
    private String csrfRepositoryRef;

    public BeanDefinition parse(Element element, ParserContext pc) {
        boolean webmvcPresent = ClassUtils.isPresent((String)DISPATCHER_SERVLET_CLASS_NAME, (ClassLoader)this.getClass().getClassLoader());
        if (webmvcPresent) {
            RootBeanDefinition beanDefinition = new RootBeanDefinition(CsrfRequestDataValueProcessor.class);
            BeanComponentDefinition componentDefinition = new BeanComponentDefinition((BeanDefinition)beanDefinition, REQUEST_DATA_VALUE_PROCESSOR);
            pc.registerBeanComponent(componentDefinition);
        }
        this.csrfRepositoryRef = element.getAttribute(ATT_REPOSITORY);
        String matcherRef = element.getAttribute(ATT_MATCHER);
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(CsrfFilter.class);
        if (!StringUtils.hasText((String)this.csrfRepositoryRef)) {
            RootBeanDefinition csrfTokenRepository = new RootBeanDefinition(HttpSessionCsrfTokenRepository.class);
            this.csrfRepositoryRef = pc.getReaderContext().generateBeanName((BeanDefinition)csrfTokenRepository);
            pc.registerBeanComponent(new BeanComponentDefinition((BeanDefinition)csrfTokenRepository, this.csrfRepositoryRef));
        }
        builder.addConstructorArgReference(this.csrfRepositoryRef);
        if (StringUtils.hasText((String)matcherRef)) {
            builder.addPropertyReference("requireCsrfProtectionMatcher", matcherRef);
        }
        return builder.getBeanDefinition();
    }

    BeanDefinition getCsrfAuthenticationStrategy() {
        BeanDefinitionBuilder csrfAuthenticationStrategy = BeanDefinitionBuilder.rootBeanDefinition(CsrfAuthenticationStrategy.class);
        csrfAuthenticationStrategy.addConstructorArgReference(this.csrfRepositoryRef);
        return csrfAuthenticationStrategy.getBeanDefinition();
    }

    BeanDefinition getCsrfLogoutHandler() {
        BeanDefinitionBuilder csrfAuthenticationStrategy = BeanDefinitionBuilder.rootBeanDefinition(CsrfLogoutHandler.class);
        csrfAuthenticationStrategy.addConstructorArgReference(this.csrfRepositoryRef);
        return csrfAuthenticationStrategy.getBeanDefinition();
    }
}

