/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web.configuration;

import java.util.Arrays;
import java.util.List;
import javax.servlet.Filter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.security.authentication.AuthenticationEventPublisher;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationTrustResolver;
import org.springframework.security.authentication.AuthenticationTrustResolverImpl;
import org.springframework.security.authentication.DefaultAuthenticationEventPublisher;
import org.springframework.security.config.annotation.ObjectPostProcessor;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.web.WebSecurityConfigurer;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.security.config.annotation.web.configurers.DefaultLoginPageConfigurer;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.web.access.intercept.FilterSecurityInterceptor;
import org.springframework.security.web.context.request.async.WebAsyncManagerIntegrationFilter;
import org.springframework.web.accept.ContentNegotiationStrategy;
import org.springframework.web.accept.HeaderContentNegotiationStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WebSecurityConfigurerAdapter
implements WebSecurityConfigurer<WebSecurity> {
    private final Log logger = LogFactory.getLog(WebSecurityConfigurerAdapter.class);
    private ApplicationContext context;
    private ContentNegotiationStrategy contentNegotiationStrategy = new HeaderContentNegotiationStrategy();
    private ObjectPostProcessor<Object> objectPostProcessor = new ObjectPostProcessor<Object>(){

        @Override
        public <T> T postProcess(T object) {
            throw new IllegalStateException(ObjectPostProcessor.class.getName() + " is a required bean. Ensure you have used @EnableWebSecurity and @Configuration");
        }
    };
    private AuthenticationManagerBuilder authenticationBuilder;
    private AuthenticationManagerBuilder parentAuthenticationBuilder;
    private boolean disableAuthenticationRegistration;
    private boolean authenticationManagerInitialized;
    private AuthenticationManager authenticationManager;
    private AuthenticationTrustResolver trustResolver = new AuthenticationTrustResolverImpl();
    private HttpSecurity http;
    private boolean disableDefaults;

    protected WebSecurityConfigurerAdapter() {
        this(false);
    }

    protected WebSecurityConfigurerAdapter(boolean disableDefaults) {
        this.disableDefaults = disableDefaults;
    }

    @Override
    protected void configure(AuthenticationManagerBuilder auth) throws Exception {
        this.disableAuthenticationRegistration = true;
    }

    protected final HttpSecurity getHttp() throws Exception {
        if (this.http != null) {
            return this.http;
        }
        DefaultAuthenticationEventPublisher eventPublisher = this.objectPostProcessor.postProcess(new DefaultAuthenticationEventPublisher());
        this.parentAuthenticationBuilder.authenticationEventPublisher((AuthenticationEventPublisher)eventPublisher);
        AuthenticationManager authenticationManager = this.authenticationManager();
        this.authenticationBuilder.parentAuthenticationManager(authenticationManager);
        this.http = new HttpSecurity(this.objectPostProcessor, this.authenticationBuilder, this.parentAuthenticationBuilder.getSharedObjects());
        this.http.setSharedObject(UserDetailsService.class, this.userDetailsService());
        this.http.setSharedObject(ApplicationContext.class, this.context);
        this.http.setSharedObject(ContentNegotiationStrategy.class, this.contentNegotiationStrategy);
        this.http.setSharedObject(AuthenticationTrustResolver.class, this.trustResolver);
        if (!this.disableDefaults) {
            ((HttpSecurity)((HttpSecurity)((HttpSecurity)((HttpSecurity)((HttpSecurity)((HttpSecurity)((HttpSecurity)((HttpSecurity)((HttpSecurity)this.http.csrf().and()).addFilter((Filter)new WebAsyncManagerIntegrationFilter()).exceptionHandling().and()).headers().and()).sessionManagement().and()).securityContext().and()).requestCache().and()).anonymous().and()).servletApi().and()).apply(new DefaultLoginPageConfigurer()).and()).logout();
        }
        this.configure(this.http);
        return this.http;
    }

    public AuthenticationManager authenticationManagerBean() throws Exception {
        return new AuthenticationManagerDelegator(this.authenticationBuilder);
    }

    protected AuthenticationManager authenticationManager() throws Exception {
        if (!this.authenticationManagerInitialized) {
            this.configure(this.parentAuthenticationBuilder);
            if (this.disableAuthenticationRegistration) {
                try {
                    this.authenticationManager = (AuthenticationManager)((AuthenticationManagerBuilder)this.context.getBean(AuthenticationManagerBuilder.class)).getOrBuild();
                }
                catch (NoSuchBeanDefinitionException e) {
                    this.logger.debug((Object)"Could not obtain the AuthenticationManagerBuilder. This is ok for now, we will try using an AuthenticationManager directly", (Throwable)e);
                }
                if (this.authenticationManager == null) {
                    try {
                        this.authenticationManager = (AuthenticationManager)this.context.getBean(AuthenticationManager.class);
                    }
                    catch (NoSuchBeanDefinitionException e) {
                        this.logger.debug((Object)"The AuthenticationManager was not found. This is ok for now as it may not be required.", (Throwable)e);
                    }
                }
            } else {
                this.authenticationManager = (AuthenticationManager)this.parentAuthenticationBuilder.build();
            }
            this.authenticationManagerInitialized = true;
        }
        return this.authenticationManager;
    }

    public UserDetailsService userDetailsServiceBean() throws Exception {
        AuthenticationManagerBuilder globalAuthBuilder = (AuthenticationManagerBuilder)this.context.getBean(AuthenticationManagerBuilder.class);
        return new UserDetailsServiceDelegator(Arrays.asList(this.parentAuthenticationBuilder, globalAuthBuilder));
    }

    protected UserDetailsService userDetailsService() {
        AuthenticationManagerBuilder globalAuthBuilder = (AuthenticationManagerBuilder)this.context.getBean(AuthenticationManagerBuilder.class);
        return new UserDetailsServiceDelegator(Arrays.asList(this.parentAuthenticationBuilder, globalAuthBuilder));
    }

    @Override
    public void init(final WebSecurity web) throws Exception {
        final HttpSecurity http = this.getHttp();
        web.addSecurityFilterChainBuilder(http).postBuildAction(new Runnable(){

            public void run() {
                FilterSecurityInterceptor securityInterceptor = http.getSharedObject(FilterSecurityInterceptor.class);
                web.securityInterceptor(securityInterceptor);
            }
        });
    }

    @Override
    public void configure(WebSecurity web) throws Exception {
    }

    @Override
    protected void configure(HttpSecurity http) throws Exception {
        this.logger.debug((Object)"Using default configure(HttpSecurity). If subclassed this will potentially override subclass configure(HttpSecurity).");
        ((HttpSecurity)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.authorizeRequests().anyRequest()).authenticated().and()).formLogin().and()).httpBasic();
    }

    @Autowired
    public void setApplicationContext(ApplicationContext context) {
        this.context = context;
    }

    @Autowired(required=false)
    public void setTrustResolver(AuthenticationTrustResolver trustResolver) {
        this.trustResolver = trustResolver;
    }

    @Autowired(required=false)
    public void setContentNegotationStrategy(ContentNegotiationStrategy contentNegotiationStrategy) {
        this.contentNegotiationStrategy = contentNegotiationStrategy;
    }

    @Autowired(required=false)
    public void setObjectPostProcessor(ObjectPostProcessor<Object> objectPostProcessor) {
        this.objectPostProcessor = objectPostProcessor;
        this.authenticationBuilder = new AuthenticationManagerBuilder(objectPostProcessor);
        this.parentAuthenticationBuilder = new AuthenticationManagerBuilder(objectPostProcessor){

            public AuthenticationManagerBuilder eraseCredentials(boolean eraseCredentials) {
                WebSecurityConfigurerAdapter.this.authenticationBuilder.eraseCredentials(eraseCredentials);
                return super.eraseCredentials(eraseCredentials);
            }
        };
    }

    static final class AuthenticationManagerDelegator
    implements AuthenticationManager {
        private AuthenticationManagerBuilder delegateBuilder;
        private AuthenticationManager delegate;
        private final Object delegateMonitor = new Object();

        AuthenticationManagerDelegator(AuthenticationManagerBuilder authentication) {
            this.delegateBuilder = authentication;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Authentication authenticate(Authentication authentication) throws AuthenticationException {
            if (this.delegate != null) {
                return this.delegate.authenticate(authentication);
            }
            Object object = this.delegateMonitor;
            synchronized (object) {
                if (this.delegate == null) {
                    this.delegate = (AuthenticationManager)this.delegateBuilder.getObject();
                    this.delegateBuilder = null;
                }
            }
            return this.delegate.authenticate(authentication);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class UserDetailsServiceDelegator
    implements UserDetailsService {
        private List<AuthenticationManagerBuilder> delegateBuilders;
        private UserDetailsService delegate;
        private final Object delegateMonitor = new Object();

        UserDetailsServiceDelegator(List<AuthenticationManagerBuilder> delegateBuilders) {
            if (delegateBuilders.contains(null)) {
                throw new IllegalArgumentException("delegateBuilders cannot contain null values. Got " + delegateBuilders);
            }
            this.delegateBuilders = delegateBuilders;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException {
            if (this.delegate != null) {
                return this.delegate.loadUserByUsername(username);
            }
            Object object = this.delegateMonitor;
            synchronized (object) {
                if (this.delegate == null) {
                    for (AuthenticationManagerBuilder delegateBuilder : this.delegateBuilders) {
                        this.delegate = delegateBuilder.getDefaultUserDetailsService();
                        if (this.delegate == null) continue;
                        break;
                    }
                    if (this.delegate == null) {
                        throw new IllegalStateException("UserDetailsService is required.");
                    }
                    this.delegateBuilders = null;
                }
            }
            return this.delegate.loadUserByUsername(username);
        }
    }
}

