/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.method.configuration;

import java.util.Map;
import org.springframework.context.annotation.AdviceMode;
import org.springframework.context.annotation.AutoProxyRegistrar;
import org.springframework.context.annotation.ImportSelector;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.security.config.annotation.method.configuration.EnableGlobalMethodSecurity;
import org.springframework.security.config.annotation.method.configuration.GlobalMethodSecurityAspectJAutoProxyRegistrar;
import org.springframework.security.config.annotation.method.configuration.GlobalMethodSecurityConfiguration;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

final class GlobalMethodSecuritySelector
implements ImportSelector {
    GlobalMethodSecuritySelector() {
    }

    public final String[] selectImports(AnnotationMetadata importingClassMetadata) {
        String autoProxyClassName;
        Class<EnableGlobalMethodSecurity> annoType = EnableGlobalMethodSecurity.class;
        Map annotationAttributes = importingClassMetadata.getAnnotationAttributes(annoType.getName(), false);
        AnnotationAttributes attributes = AnnotationAttributes.fromMap((Map)annotationAttributes);
        Assert.notNull((Object)attributes, (String)String.format("@%s is not present on importing class '%s' as expected", annoType.getSimpleName(), importingClassMetadata.getClassName()));
        Class importingClass = ClassUtils.resolveClassName((String)importingClassMetadata.getClassName(), (ClassLoader)ClassUtils.getDefaultClassLoader());
        boolean skipMethodSecurityConfiguration = GlobalMethodSecurityConfiguration.class.isAssignableFrom(importingClass);
        AdviceMode mode = (AdviceMode)attributes.getEnum("mode");
        String string = autoProxyClassName = AdviceMode.PROXY == mode ? AutoProxyRegistrar.class.getName() : GlobalMethodSecurityAspectJAutoProxyRegistrar.class.getName();
        if (skipMethodSecurityConfiguration) {
            return new String[]{autoProxyClassName};
        }
        return new String[]{autoProxyClassName, GlobalMethodSecurityConfiguration.class.getName()};
    }
}

