/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web.reactive;

import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.web.server.HttpSecurity;
import org.springframework.security.web.server.SecurityWebFilterChain;
import org.springframework.security.web.server.WebFilterChainFilter;
import org.springframework.util.ObjectUtils;

@Configuration
public class WebFluxSecurityConfiguration {
    private static final String BEAN_NAME_PREFIX = "org.springframework.security.config.annotation.web.reactive.WebFluxSecurityConfiguration.";
    private static final String SPRING_SECURITY_WEBFILTERCHAINFILTER_BEAN_NAME = "org.springframework.security.config.annotation.web.reactive.WebFluxSecurityConfiguration.WebFilterChainFilter";
    @Autowired(required=false)
    private List<SecurityWebFilterChain> securityWebFilterChains;
    @Autowired
    ApplicationContext context;

    @Bean(value={"org.springframework.security.config.annotation.web.reactive.WebFluxSecurityConfiguration.WebFilterChainFilter"})
    public WebFilterChainFilter springSecurityWebFilterChainFilter() {
        return WebFilterChainFilter.fromSecurityWebFilterChainsList(this.getSecurityWebFilterChains());
    }

    private List<SecurityWebFilterChain> getSecurityWebFilterChains() {
        List<SecurityWebFilterChain> result = this.securityWebFilterChains;
        if (ObjectUtils.isEmpty(result)) {
            return this.defaultSecurityWebFilterChains();
        }
        return result;
    }

    private List<SecurityWebFilterChain> defaultSecurityWebFilterChains() {
        HttpSecurity http = (HttpSecurity)this.context.getBean(HttpSecurity.class);
        http.authorizeExchange().anyExchange().authenticated();
        return Arrays.asList(http.build());
    }
}

