/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web.configurers.oauth2.client;

import javax.servlet.Filter;
import org.springframework.context.ApplicationContext;
import org.springframework.security.config.annotation.web.HttpSecurityBuilder;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.client.web.OAuth2AuthorizationRequestRedirectFilter;
import org.springframework.util.Assert;

public final class ImplicitGrantConfigurer<B extends HttpSecurityBuilder<B>>
extends AbstractHttpConfigurer<ImplicitGrantConfigurer<B>, B> {
    private String authorizationRequestBaseUri;

    public ImplicitGrantConfigurer<B> authorizationRequestBaseUri(String authorizationRequestBaseUri) {
        Assert.hasText((String)authorizationRequestBaseUri, (String)"authorizationRequestBaseUri cannot be empty");
        this.authorizationRequestBaseUri = authorizationRequestBaseUri;
        return this;
    }

    public ImplicitGrantConfigurer<B> clientRegistrationRepository(ClientRegistrationRepository clientRegistrationRepository) {
        Assert.notNull((Object)clientRegistrationRepository, (String)"clientRegistrationRepository cannot be null");
        ((HttpSecurityBuilder)this.getBuilder()).setSharedObject(ClientRegistrationRepository.class, clientRegistrationRepository);
        return this;
    }

    @Override
    public void configure(B http) throws Exception {
        OAuth2AuthorizationRequestRedirectFilter authorizationRequestFilter = new OAuth2AuthorizationRequestRedirectFilter(this.getAuthorizationRequestBaseUri(), this.getClientRegistrationRepository());
        http.addFilter((Filter)this.postProcess(authorizationRequestFilter));
    }

    private String getAuthorizationRequestBaseUri() {
        return this.authorizationRequestBaseUri != null ? this.authorizationRequestBaseUri : "/oauth2/authorization";
    }

    private ClientRegistrationRepository getClientRegistrationRepository() {
        ClientRegistrationRepository clientRegistrationRepository = ((HttpSecurityBuilder)this.getBuilder()).getSharedObject(ClientRegistrationRepository.class);
        if (clientRegistrationRepository == null) {
            clientRegistrationRepository = this.getClientRegistrationRepositoryBean();
            ((HttpSecurityBuilder)this.getBuilder()).setSharedObject(ClientRegistrationRepository.class, clientRegistrationRepository);
        }
        return clientRegistrationRepository;
    }

    private ClientRegistrationRepository getClientRegistrationRepositoryBean() {
        return (ClientRegistrationRepository)((HttpSecurityBuilder)this.getBuilder()).getSharedObject(ApplicationContext.class).getBean(ClientRegistrationRepository.class);
    }
}

