/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web.reactive;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Scope;
import org.springframework.context.expression.BeanFactoryResolver;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.expression.BeanResolver;
import org.springframework.security.authentication.ReactiveAuthenticationManager;
import org.springframework.security.authentication.UserDetailsRepositoryReactiveAuthenticationManager;
import org.springframework.security.config.web.server.ServerHttpSecurity;
import org.springframework.security.core.userdetails.ReactiveUserDetailsPasswordService;
import org.springframework.security.core.userdetails.ReactiveUserDetailsService;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.web.reactive.result.method.annotation.AuthenticationPrincipalArgumentResolver;
import org.springframework.web.reactive.config.WebFluxConfigurer;
import org.springframework.web.reactive.result.method.HandlerMethodArgumentResolver;
import org.springframework.web.reactive.result.method.annotation.ArgumentResolverConfigurer;

class ServerHttpSecurityConfiguration
implements WebFluxConfigurer {
    private static final String BEAN_NAME_PREFIX = "org.springframework.security.config.annotation.web.reactive.HttpSecurityConfiguration.";
    private static final String HTTPSECURITY_BEAN_NAME = "org.springframework.security.config.annotation.web.reactive.HttpSecurityConfiguration.httpSecurity";
    @Autowired(required=false)
    private ReactiveAdapterRegistry adapterRegistry = new ReactiveAdapterRegistry();
    @Autowired(required=false)
    private ReactiveAuthenticationManager authenticationManager;
    @Autowired(required=false)
    private ReactiveUserDetailsService reactiveUserDetailsService;
    @Autowired(required=false)
    private PasswordEncoder passwordEncoder;
    @Autowired(required=false)
    private ReactiveUserDetailsPasswordService userDetailsPasswordService;
    @Autowired(required=false)
    private BeanFactory beanFactory;

    ServerHttpSecurityConfiguration() {
    }

    public void configureArgumentResolvers(ArgumentResolverConfigurer configurer) {
        configurer.addCustomResolver(new HandlerMethodArgumentResolver[]{this.authenticationPrincipalArgumentResolver()});
    }

    @Bean
    public AuthenticationPrincipalArgumentResolver authenticationPrincipalArgumentResolver() {
        AuthenticationPrincipalArgumentResolver resolver = new AuthenticationPrincipalArgumentResolver(this.adapterRegistry);
        if (this.beanFactory != null) {
            resolver.setBeanResolver((BeanResolver)new BeanFactoryResolver(this.beanFactory));
        }
        return resolver;
    }

    @Bean(value={"org.springframework.security.config.annotation.web.reactive.HttpSecurityConfiguration.httpSecurity"})
    @Scope(value="prototype")
    public ServerHttpSecurity httpSecurity() {
        ContextAwareServerHttpSecurity http = new ContextAwareServerHttpSecurity();
        return http.authenticationManager(this.authenticationManager()).headers().and().logout().and();
    }

    private ReactiveAuthenticationManager authenticationManager() {
        if (this.authenticationManager != null) {
            return this.authenticationManager;
        }
        if (this.reactiveUserDetailsService != null) {
            UserDetailsRepositoryReactiveAuthenticationManager manager = new UserDetailsRepositoryReactiveAuthenticationManager(this.reactiveUserDetailsService);
            if (this.passwordEncoder != null) {
                manager.setPasswordEncoder(this.passwordEncoder);
            }
            manager.setUserDetailsPasswordService(this.userDetailsPasswordService);
            return manager;
        }
        return null;
    }

    private static class ContextAwareServerHttpSecurity
    extends ServerHttpSecurity
    implements ApplicationContextAware {
        private ContextAwareServerHttpSecurity() {
        }

        @Override
        public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
            super.setApplicationContext(applicationContext);
        }
    }
}

