/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.oauth2.client.oidc;

import com.nimbusds.oauth2.sdk.GrantType;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.openid.connect.sdk.op.OIDCProviderMetadata;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.ClientAuthenticationMethod;
import org.springframework.web.client.RestTemplate;

public final class OidcConfigurationProvider {
    public static ClientRegistration.Builder issuer(String issuer) {
        String openidConfiguration = OidcConfigurationProvider.getOpenidConfiguration(issuer);
        OIDCProviderMetadata metadata = OidcConfigurationProvider.parse(openidConfiguration);
        String metadataIssuer = metadata.getIssuer().getValue();
        if (!issuer.equals(metadataIssuer)) {
            throw new IllegalStateException("The Issuer \"" + metadataIssuer + "\" provided in the OpenID Configuration did not match the requested issuer \"" + issuer + "\"");
        }
        String name = URI.create(issuer).getHost();
        ClientAuthenticationMethod method = OidcConfigurationProvider.getClientAuthenticationMethod(issuer, metadata.getTokenEndpointAuthMethods());
        List grantTypes = metadata.getGrantTypes();
        if (grantTypes != null && !grantTypes.contains(GrantType.AUTHORIZATION_CODE)) {
            throw new IllegalArgumentException("Only AuthorizationGrantType.AUTHORIZATION_CODE is supported. The issuer \"" + issuer + "\" returned a configuration of " + grantTypes);
        }
        List<String> scopes = OidcConfigurationProvider.getScopes(metadata);
        return ClientRegistration.withRegistrationId((String)name).userNameAttributeName("sub").scope(scopes).authorizationGrantType(AuthorizationGrantType.AUTHORIZATION_CODE).clientAuthenticationMethod(method).redirectUriTemplate("{baseUrl}/{action}/oauth2/code/{registrationId}").authorizationUri(metadata.getAuthorizationEndpointURI().toASCIIString()).jwkSetUri(metadata.getJWKSetURI().toASCIIString()).userInfoUri(metadata.getUserInfoEndpointURI().toASCIIString()).tokenUri(metadata.getTokenEndpointURI().toASCIIString()).clientName(issuer);
    }

    private static String getOpenidConfiguration(String issuer) {
        RestTemplate rest = new RestTemplate();
        try {
            return (String)rest.getForObject(issuer + "/.well-known/openid-configuration", String.class, new Object[0]);
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException("Unable to resolve the OpenID Configuration with the provided Issuer of \"" + issuer + "\"", e);
        }
    }

    private static ClientAuthenticationMethod getClientAuthenticationMethod(String issuer, List<com.nimbusds.oauth2.sdk.auth.ClientAuthenticationMethod> metadataAuthMethods) {
        if (metadataAuthMethods == null || metadataAuthMethods.contains(com.nimbusds.oauth2.sdk.auth.ClientAuthenticationMethod.CLIENT_SECRET_BASIC)) {
            return ClientAuthenticationMethod.BASIC;
        }
        if (metadataAuthMethods.contains(com.nimbusds.oauth2.sdk.auth.ClientAuthenticationMethod.CLIENT_SECRET_POST)) {
            return ClientAuthenticationMethod.POST;
        }
        throw new IllegalArgumentException("Only ClientAuthenticationMethod.BASIC and ClientAuthenticationMethod.POST are supported. The issuer \"" + issuer + "\" returned a configuration of " + metadataAuthMethods);
    }

    private static List<String> getScopes(OIDCProviderMetadata metadata) {
        Scope scope = metadata.getScopes();
        if (scope == null) {
            return Collections.singletonList("openid");
        }
        return scope.toStringList();
    }

    private static OIDCProviderMetadata parse(String body) {
        try {
            return OIDCProviderMetadata.parse((String)body);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    private OidcConfigurationProvider() {
    }
}

