/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.springframework.context.ApplicationContext;
import org.springframework.http.HttpMethod;
import org.springframework.security.access.hierarchicalroles.NullRoleHierarchy;
import org.springframework.security.access.hierarchicalroles.RoleHierarchy;
import org.springframework.security.authorization.AuthenticatedAuthorizationManager;
import org.springframework.security.authorization.AuthorityAuthorizationManager;
import org.springframework.security.authorization.AuthorizationDecision;
import org.springframework.security.authorization.AuthorizationManager;
import org.springframework.security.authorization.AuthorizationResult;
import org.springframework.security.config.annotation.web.AbstractRequestMatcherDsl;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.core.GrantedAuthorityDefaults;
import org.springframework.security.web.access.IpAddressAuthorizationManager;
import org.springframework.security.web.access.intercept.RequestAuthorizationContext;
import org.springframework.security.web.servlet.util.matcher.PathPatternRequestMatcher;
import org.springframework.security.web.util.matcher.AnyRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\t\b\u0016\u00a2\u0006\u0004\b\u0002\u0010\u0003B\u0011\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0002\u0010\u0006J\u001e\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015J\u001c\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u000b2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015J$\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0017\u001a\u00020\u000b2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015J$\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u000b2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015J,\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u000b2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015J\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u001c\u001a\u00020\u000bJ%\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0012\u0010\u001e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\u001f\"\u00020\u000b\u00a2\u0006\u0002\u0010 J\u0014\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\"\u001a\u00020\u000bJ%\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0012\u0010$\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\u001f\"\u00020\u000b\u00a2\u0006\u0002\u0010 J\u0014\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010&\u001a\u00020\u000bJ#\u00100\u001a\u0018\u0012\u000e\u0012\f02R\b\u0012\u0004\u0012\u00020403\u0012\u0004\u0012\u00020\u001101H\u0000\u00a2\u0006\u0002\b5J\u0010\u00106\u001a\u00020\u000b2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0010\u00107\u001a\u00020\r2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u001c\u00108\u001a\b\u0012\u0004\u0012\u00020\u0016092\f\u0010:\u001a\b\u0012\u0004\u0012\u00020\u001609H\u0002R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u0017\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010)R\u0017\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010)R\u0017\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u0010)\u00a8\u0006;"}, d2={"Lorg/springframework/security/config/annotation/web/AuthorizeHttpRequestsDsl;", "Lorg/springframework/security/config/annotation/web/AbstractRequestMatcherDsl;", "<init>", "()V", "context", "Lorg/springframework/context/ApplicationContext;", "(Lorg/springframework/context/ApplicationContext;)V", "authorizationRules", "", "Lorg/springframework/security/config/annotation/web/AbstractRequestMatcherDsl$AuthorizationManagerRule;", "rolePrefix", "", "roleHierarchy", "Lorg/springframework/security/access/hierarchicalroles/RoleHierarchy;", "PATTERN_TYPE", "Lorg/springframework/security/config/annotation/web/AbstractRequestMatcherDsl$PatternType;", "authorize", "", "matches", "Lorg/springframework/security/web/util/matcher/RequestMatcher;", "access", "Lorg/springframework/security/authorization/AuthorizationManager;", "Lorg/springframework/security/web/access/intercept/RequestAuthorizationContext;", "pattern", "method", "Lorg/springframework/http/HttpMethod;", "servletPath", "hasAuthority", "authority", "hasAnyAuthority", "authorities", "", "([Ljava/lang/String;)Lorg/springframework/security/authorization/AuthorizationManager;", "hasRole", "role", "hasAnyRole", "roles", "hasIpAddress", "ipAddress", "permitAll", "getPermitAll", "()Lorg/springframework/security/authorization/AuthorizationManager;", "denyAll", "getDenyAll", "authenticated", "getAuthenticated", "fullyAuthenticated", "getFullyAuthenticated", "get", "Lkotlin/Function1;", "Lorg/springframework/security/config/annotation/web/configurers/AuthorizeHttpRequestsConfigurer$AuthorizationManagerRequestMatcherRegistry;", "Lorg/springframework/security/config/annotation/web/configurers/AuthorizeHttpRequestsConfigurer;", "Lorg/springframework/security/config/annotation/web/builders/HttpSecurity;", "get$spring_security_config", "resolveRolePrefix", "resolveRoleHierarchy", "withRoleHierarchy", "Lorg/springframework/security/authorization/AuthorityAuthorizationManager;", "manager", "spring-security-config"})
@SourceDebugExtension(value={"SMAP\nAuthorizeHttpRequestsDsl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AuthorizeHttpRequestsDsl.kt\norg/springframework/security/config/annotation/web/AuthorizeHttpRequestsDsl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,311:1\n1869#2,2:312\n*S KotlinDebug\n*F\n+ 1 AuthorizeHttpRequestsDsl.kt\norg/springframework/security/config/annotation/web/AuthorizeHttpRequestsDsl\n*L\n261#1:312,2\n*E\n"})
public final class AuthorizeHttpRequestsDsl
extends AbstractRequestMatcherDsl {
    @NotNull
    private final List<AbstractRequestMatcherDsl.AuthorizationManagerRule> authorizationRules;
    @NotNull
    private final String rolePrefix;
    @NotNull
    private final RoleHierarchy roleHierarchy;
    @NotNull
    private final AbstractRequestMatcherDsl.PatternType PATTERN_TYPE;
    @NotNull
    private final AuthorizationManager<RequestAuthorizationContext> permitAll;
    @NotNull
    private final AuthorizationManager<RequestAuthorizationContext> denyAll;
    @NotNull
    private final AuthorizationManager<RequestAuthorizationContext> authenticated;
    @NotNull
    private final AuthorizationManager<RequestAuthorizationContext> fullyAuthenticated;

    public final void authorize(@NotNull RequestMatcher matches, @NotNull AuthorizationManager<RequestAuthorizationContext> access) {
        Intrinsics.checkNotNullParameter((Object)matches, (String)"matches");
        Intrinsics.checkNotNullParameter(access, (String)"access");
        this.authorizationRules.add(new AbstractRequestMatcherDsl.MatcherAuthorizationManagerRule(matches, access));
    }

    public static /* synthetic */ void authorize$default(AuthorizeHttpRequestsDsl authorizeHttpRequestsDsl, RequestMatcher requestMatcher, AuthorizationManager authorizationManager, int n, Object object) {
        if ((n & 1) != 0) {
            RequestMatcher requestMatcher2 = AnyRequestMatcher.INSTANCE;
            Intrinsics.checkNotNullExpressionValue((Object)requestMatcher2, (String)"INSTANCE");
            requestMatcher = requestMatcher2;
        }
        authorizeHttpRequestsDsl.authorize(requestMatcher, (AuthorizationManager<RequestAuthorizationContext>)authorizationManager);
    }

    public final void authorize(@NotNull String pattern, @NotNull AuthorizationManager<RequestAuthorizationContext> access) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        Intrinsics.checkNotNullParameter(access, (String)"access");
        this.authorizationRules.add(new AbstractRequestMatcherDsl.PatternAuthorizationManagerRule(pattern, this.PATTERN_TYPE, null, null, access, 12, null));
    }

    public final void authorize(@NotNull HttpMethod method, @NotNull String pattern, @NotNull AuthorizationManager<RequestAuthorizationContext> access) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        Intrinsics.checkNotNullParameter(access, (String)"access");
        this.authorizationRules.add(new AbstractRequestMatcherDsl.PatternAuthorizationManagerRule(pattern, this.PATTERN_TYPE, null, method, access, 4, null));
    }

    public final void authorize(@NotNull String pattern, @NotNull String servletPath, @NotNull AuthorizationManager<RequestAuthorizationContext> access) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        Intrinsics.checkNotNullParameter((Object)servletPath, (String)"servletPath");
        Intrinsics.checkNotNullParameter(access, (String)"access");
        this.authorizationRules.add(new AbstractRequestMatcherDsl.PatternAuthorizationManagerRule(pattern, this.PATTERN_TYPE, servletPath, null, access, 8, null));
    }

    public final void authorize(@NotNull HttpMethod method, @NotNull String pattern, @NotNull String servletPath, @NotNull AuthorizationManager<RequestAuthorizationContext> access) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        Intrinsics.checkNotNullParameter((Object)servletPath, (String)"servletPath");
        Intrinsics.checkNotNullParameter(access, (String)"access");
        this.authorizationRules.add(new AbstractRequestMatcherDsl.PatternAuthorizationManagerRule(pattern, this.PATTERN_TYPE, servletPath, method, access));
    }

    @NotNull
    public final AuthorizationManager<RequestAuthorizationContext> hasAuthority(@NotNull String authority) {
        Intrinsics.checkNotNullParameter((Object)authority, (String)"authority");
        AuthorityAuthorizationManager manager = AuthorityAuthorizationManager.hasAuthority((String)authority);
        Intrinsics.checkNotNull((Object)manager);
        return (AuthorizationManager)this.withRoleHierarchy((AuthorityAuthorizationManager<RequestAuthorizationContext>)manager);
    }

    @NotNull
    public final AuthorizationManager<RequestAuthorizationContext> hasAnyAuthority(String ... authorities) {
        Intrinsics.checkNotNullParameter((Object)authorities, (String)"authorities");
        AuthorityAuthorizationManager manager = AuthorityAuthorizationManager.hasAnyAuthority((String[])Arrays.copyOf(authorities, authorities.length));
        Intrinsics.checkNotNull((Object)manager);
        return (AuthorizationManager)this.withRoleHierarchy((AuthorityAuthorizationManager<RequestAuthorizationContext>)manager);
    }

    @NotNull
    public final AuthorizationManager<RequestAuthorizationContext> hasRole(@NotNull String role) {
        Intrinsics.checkNotNullParameter((Object)role, (String)"role");
        String[] stringArray = new String[]{role};
        AuthorityAuthorizationManager manager = AuthorityAuthorizationManager.hasAnyRole((String)this.rolePrefix, (String[])stringArray);
        Intrinsics.checkNotNull((Object)manager);
        return (AuthorizationManager)this.withRoleHierarchy((AuthorityAuthorizationManager<RequestAuthorizationContext>)manager);
    }

    @NotNull
    public final AuthorizationManager<RequestAuthorizationContext> hasAnyRole(String ... roles) {
        Intrinsics.checkNotNullParameter((Object)roles, (String)"roles");
        AuthorityAuthorizationManager manager = AuthorityAuthorizationManager.hasAnyRole((String)this.rolePrefix, (String[])Arrays.copyOf(roles, roles.length));
        Intrinsics.checkNotNull((Object)manager);
        return (AuthorizationManager)this.withRoleHierarchy((AuthorityAuthorizationManager<RequestAuthorizationContext>)manager);
    }

    @NotNull
    public final AuthorizationManager<RequestAuthorizationContext> hasIpAddress(@NotNull String ipAddress) {
        Intrinsics.checkNotNullParameter((Object)ipAddress, (String)"ipAddress");
        IpAddressAuthorizationManager ipAddressAuthorizationManager = IpAddressAuthorizationManager.hasIpAddress((String)ipAddress);
        Intrinsics.checkNotNullExpressionValue((Object)ipAddressAuthorizationManager, (String)"hasIpAddress(...)");
        return (AuthorizationManager)ipAddressAuthorizationManager;
    }

    @NotNull
    public final AuthorizationManager<RequestAuthorizationContext> getPermitAll() {
        return this.permitAll;
    }

    @NotNull
    public final AuthorizationManager<RequestAuthorizationContext> getDenyAll() {
        return this.denyAll;
    }

    @NotNull
    public final AuthorizationManager<RequestAuthorizationContext> getAuthenticated() {
        return this.authenticated;
    }

    @NotNull
    public final AuthorizationManager<RequestAuthorizationContext> getFullyAuthenticated() {
        return this.fullyAuthenticated;
    }

    @NotNull
    public final Function1<AuthorizeHttpRequestsConfigurer.AuthorizationManagerRequestMatcherRegistry, Unit> get$spring_security_config() {
        return arg_0 -> AuthorizeHttpRequestsDsl.get$lambda$3(this, arg_0);
    }

    public AuthorizeHttpRequestsDsl() {
        this.authorizationRules = new ArrayList();
        this.PATTERN_TYPE = AbstractRequestMatcherDsl.PatternType.PATH;
        this.permitAll = AuthorizeHttpRequestsDsl::permitAll$lambda$0;
        this.denyAll = AuthorizeHttpRequestsDsl::denyAll$lambda$1;
        AuthenticatedAuthorizationManager authenticatedAuthorizationManager = AuthenticatedAuthorizationManager.authenticated();
        Intrinsics.checkNotNullExpressionValue((Object)authenticatedAuthorizationManager, (String)"authenticated(...)");
        this.authenticated = (AuthorizationManager)authenticatedAuthorizationManager;
        AuthenticatedAuthorizationManager authenticatedAuthorizationManager2 = AuthenticatedAuthorizationManager.fullyAuthenticated();
        Intrinsics.checkNotNullExpressionValue((Object)authenticatedAuthorizationManager2, (String)"fullyAuthenticated(...)");
        this.fullyAuthenticated = (AuthorizationManager)authenticatedAuthorizationManager2;
        this.rolePrefix = "ROLE_";
        this.roleHierarchy = (RoleHierarchy)new NullRoleHierarchy();
    }

    public AuthorizeHttpRequestsDsl(@NotNull ApplicationContext context) {
        RoleHierarchy roleHierarchy;
        String rolePrefix;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.authorizationRules = new ArrayList();
        this.PATTERN_TYPE = AbstractRequestMatcherDsl.PatternType.PATH;
        this.permitAll = AuthorizeHttpRequestsDsl::permitAll$lambda$0;
        this.denyAll = AuthorizeHttpRequestsDsl::denyAll$lambda$1;
        AuthenticatedAuthorizationManager authenticatedAuthorizationManager = AuthenticatedAuthorizationManager.authenticated();
        Intrinsics.checkNotNullExpressionValue((Object)authenticatedAuthorizationManager, (String)"authenticated(...)");
        this.authenticated = (AuthorizationManager)authenticatedAuthorizationManager;
        AuthenticatedAuthorizationManager authenticatedAuthorizationManager2 = AuthenticatedAuthorizationManager.fullyAuthenticated();
        Intrinsics.checkNotNullExpressionValue((Object)authenticatedAuthorizationManager2, (String)"fullyAuthenticated(...)");
        this.fullyAuthenticated = (AuthorizationManager)authenticatedAuthorizationManager2;
        this.rolePrefix = rolePrefix = this.resolveRolePrefix(context);
        this.roleHierarchy = roleHierarchy = this.resolveRoleHierarchy(context);
    }

    private final String resolveRolePrefix(ApplicationContext context) {
        String[] stringArray = context.getBeanNamesForType(GrantedAuthorityDefaults.class);
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"getBeanNamesForType(...)");
        String[] beanNames = stringArray;
        if (!(beanNames.length == 0)) {
            String string = ((GrantedAuthorityDefaults)context.getBean(GrantedAuthorityDefaults.class)).getRolePrefix();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getRolePrefix(...)");
            return string;
        }
        return "ROLE_";
    }

    private final RoleHierarchy resolveRoleHierarchy(ApplicationContext context) {
        String[] stringArray = context.getBeanNamesForType(RoleHierarchy.class);
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"getBeanNamesForType(...)");
        String[] beanNames = stringArray;
        if (!(beanNames.length == 0)) {
            Object object = context.getBean(RoleHierarchy.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getBean(...)");
            return (RoleHierarchy)object;
        }
        return (RoleHierarchy)new NullRoleHierarchy();
    }

    private final AuthorityAuthorizationManager<RequestAuthorizationContext> withRoleHierarchy(AuthorityAuthorizationManager<RequestAuthorizationContext> manager) {
        manager.setRoleHierarchy(this.roleHierarchy);
        return manager;
    }

    private static final AuthorizationResult permitAll$lambda$0(Supplier supplier, RequestAuthorizationContext requestAuthorizationContext) {
        Intrinsics.checkNotNullParameter((Object)supplier, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)requestAuthorizationContext, (String)"<unused var>");
        return (AuthorizationResult)new AuthorizationDecision(true);
    }

    private static final AuthorizationResult denyAll$lambda$1(Supplier supplier, RequestAuthorizationContext requestAuthorizationContext) {
        Intrinsics.checkNotNullParameter((Object)supplier, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)requestAuthorizationContext, (String)"<unused var>");
        return (AuthorizationResult)new AuthorizationDecision(false);
    }

    private static final Unit get$lambda$3(AuthorizeHttpRequestsDsl this$0, AuthorizeHttpRequestsConfigurer.AuthorizationManagerRequestMatcherRegistry requests) {
        Intrinsics.checkNotNullParameter((Object)requests, (String)"requests");
        Iterable $this$forEach$iv = this$0.authorizationRules;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AbstractRequestMatcherDsl.AuthorizationManagerRule rule = (AbstractRequestMatcherDsl.AuthorizationManagerRule)element$iv;
            boolean bl = false;
            AbstractRequestMatcherDsl.AuthorizationManagerRule authorizationManagerRule = rule;
            if (authorizationManagerRule instanceof AbstractRequestMatcherDsl.MatcherAuthorizationManagerRule) {
                RequestMatcher[] requestMatcherArray = new RequestMatcher[]{((AbstractRequestMatcherDsl.MatcherAuthorizationManagerRule)rule).getMatcher()};
                ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)requests.requestMatchers(requestMatcherArray)).access(((AbstractRequestMatcherDsl.MatcherAuthorizationManagerRule)rule).getRule());
                continue;
            }
            if (!(authorizationManagerRule instanceof AbstractRequestMatcherDsl.PatternAuthorizationManagerRule)) continue;
            Object object = requests.getApplicationContext().getBeanProvider(PathPatternRequestMatcher.Builder.class).getIfUnique(PathPatternRequestMatcher::withDefaults);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getIfUnique(...)");
            PathPatternRequestMatcher.Builder builder = (PathPatternRequestMatcher.Builder)object;
            if (((AbstractRequestMatcherDsl.PatternAuthorizationManagerRule)rule).getServletPath() != null) {
                PathPatternRequestMatcher.Builder builder2 = builder.basePath(((AbstractRequestMatcherDsl.PatternAuthorizationManagerRule)rule).getServletPath());
                Intrinsics.checkNotNullExpressionValue((Object)builder2, (String)"basePath(...)");
                builder = builder2;
            }
            RequestMatcher[] requestMatcherArray = new RequestMatcher[]{builder.matcher(((AbstractRequestMatcherDsl.PatternAuthorizationManagerRule)rule).getHttpMethod(), ((AbstractRequestMatcherDsl.PatternAuthorizationManagerRule)rule).getPattern())};
            ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)requests.requestMatchers(requestMatcherArray)).access(((AbstractRequestMatcherDsl.PatternAuthorizationManagerRule)rule).getRule());
        }
        return Unit.INSTANCE;
    }
}

